<?php
/**
 * 设置定时任务脚本
 * 
 * 此脚本用于帮助用户设置cron任务，以便每天自动运行通知脚本
 */

// 获取当前脚本的绝对路径
$currentDir = __DIR__;
$notifyScript = $currentDir . '/notify.php';

// 检查通知脚本是否存在
if (!file_exists($notifyScript)) {
    echo "错误：通知脚本不存在，请先创建 notify.php 文件\n";
    exit(1);
}

// 生成cron表达式
// 默认每天早上9点运行
$cronExpression = "0 9 * * *";

// 生成cron命令
$cronCommand = "{$cronExpression} php {$notifyScript} >> {$currentDir}/data/cron_log.txt 2>&1";

// 显示设置说明
echo "=================================================\n";
echo "            VPS服务器到期通知定时任务设置          \n";
echo "=================================================\n\n";

echo "要设置每天自动运行通知脚本，请按照以下步骤操作：\n\n";

echo "1. 运行以下命令编辑当前用户的crontab：\n";
echo "   crontab -e\n\n";

echo "2. 在打开的编辑器中添加以下行：\n";
echo "   {$cronCommand}\n\n";

echo "3. 保存并退出编辑器\n\n";

echo "这将设置通知脚本在每天早上9点运行，并将日志保存到 data/cron_log.txt 文件中。\n\n";

echo "如果您想更改运行时间，可以修改cron表达式。例如：\n";
echo "- 每天早上8点运行：0 8 * * *\n";
echo "- 每天晚上10点运行：0 22 * * *\n";
echo "- 每天早上9点和下午3点运行：0 9,15 * * *\n\n";

echo "您也可以使用以下命令直接添加cron任务（无需手动编辑）：\n";
echo "(crontab -l 2>/dev/null; echo \"{$cronCommand}\") | crontab -\n\n";

echo "=================================================\n";

// 提供直接设置的选项
echo "是否要立即设置cron任务？(y/n): ";
$handle = fopen("php://stdin", "r");
$line = trim(fgets($handle));
fclose($handle);

if (strtolower($line) === 'y' || strtolower($line) === 'yes') {
    // 获取当前的crontab
    exec('crontab -l 2>/dev/null', $crontab, $exitCode);
    
    // 检查是否已经存在相同的任务
    $taskExists = false;
    foreach ($crontab as $line) {
        if (strpos($line, $notifyScript) !== false) {
            $taskExists = true;
            break;
        }
    }
    
    if ($taskExists) {
        echo "通知任务已经存在于crontab中。\n";
    } else {
        // 添加新任务
        $crontab[] = $cronCommand;
        $newCrontab = implode("\n", $crontab) . "\n";
        
        // 创建临时文件
        $tempFile = tempnam(sys_get_temp_dir(), 'cron');
        file_put_contents($tempFile, $newCrontab);
        
        // 设置新的crontab
        exec("crontab {$tempFile}", $output, $exitCode);
        unlink($tempFile);
        
        if ($exitCode === 0) {
            echo "成功设置cron任务！通知脚本将在每天早上9点运行。\n";
        } else {
            echo "设置cron任务失败，请手动设置。\n";
        }
    }
} else {
    echo "您选择了不立即设置cron任务。您可以稍后按照上述说明手动设置。\n";
}

echo "\n完成！\n";