<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>服务商管理 - VPS服务器续期管理系统</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="index.php">
                    <img src="assets/images/logo.svg" alt="Logo" width="32" height="32" class="me-2">
                    VPS服务器续期管理系统
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="index.php">服务器管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="providers.php">服务商管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">分类管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="currencies.php">货币管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="config.php">通知配置</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">退出登录</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">服务商管理</h5>
                                <button type="button" class="btn btn-primary btn-sm" onclick="showAddProviderModal()">添加服务商</button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="providerList">
                                <!-- 服务商列表将在这里动态加载 -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- 添加/编辑服务商模态框 -->
    <div class="modal fade" id="providerModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="providerModalTitle">添加服务商</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="providerForm">
                        <input type="hidden" id="providerId" name="providerId">
                        <div class="mb-3">
                            <label for="providerName" class="form-label">服务商名称</label>
                            <input type="text" class="form-control" id="providerName" name="providerName" required placeholder="例如：Vultr、DigitalOcean、阿里云等">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary" form="providerForm">保存</button>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/providers.js"></script>
</body>
</html>