<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>货币管理 - VPS服务器续期管理系统</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        .spin {
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">VPS服务器续期管理系统</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">服务器管理</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="providers.php">服务商管理</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="categories.php">分类管理</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="currencies.php">货币管理</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="config.php">通知配置</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">退出登录</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                <h5 class="mb-0">货币管理</h5>
                <div>
                    <button class="btn btn-success me-2" onclick="currencyManager.updateAllRates()" id="updateRatesBtn">
                        <i class="bi bi-arrow-clockwise"></i> 一键更新汇率
                    </button>
                    <button class="btn btn-primary" onclick="currencyManager.showAddModal()">添加货币</button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>货币代码</th>
                                <th>汇率 (1外币=?人民币)</th>
                                <th>说明</th>
                                <th>操作</th>
                            </tr>
                        </thead>
                        <tbody id="currencyList">
                            <!-- 货币列表将通过JavaScript动态加载 -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- 添加/编辑货币模态框 -->
    <div class="modal fade" id="currencyModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="currencyModalTitle">添加货币</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="currencyForm">
                        <input type="hidden" id="editMode" value="add">
                        <div class="mb-3">
                            <label for="currencyCode" class="form-label">货币代码</label>
                            <input type="text" class="form-control" id="currencyCode" name="currencyCode" required>
                            <div class="form-text">例如: USD, EUR, JPY</div>
                        </div>
                        <div class="mb-3">
                            <label for="currencyName" class="form-label">中文名称</label>
                            <input type="text" class="form-control" id="currencyName" name="currencyName" required>
                            <div class="form-text">例如: 美元, 欧元, 日元</div>
                        </div>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle"></i> 汇率将在保存时自动从网络获取最新数据
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="button" class="btn btn-primary" onclick="currencyManager.saveCurrency()">保存</button>
                </div>
            </div>
        </div>
    </div>

    <!-- 警告提示框 -->
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div id="alertToast" class="toast" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <strong class="me-auto" id="alertTitle">提示</strong>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body" id="alertMessage"></div>
        </div>
    </div>

    <!-- 加载指示器 -->
    <div id="loadingIndicator" class="position-fixed top-0 start-0 w-100 h-100 justify-content-center align-items-center" style="background-color: rgba(0,0,0,0.5); z-index: 9999; display: none;">
        <div class="spinner-border text-light" role="status">
            <span class="visually-hidden">加载中...</span>
        </div>
    </div>

    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/currency.js"></script>
</body>
</html>