<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>通知配置 - VPS服务器续期管理系统</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="index.php">
                    <img src="assets/images/logo.svg" alt="Logo" width="32" height="32" class="me-2">
                    VPS服务器续期管理系统
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="index.php">服务器管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="providers.php">服务商管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">分类管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="currencies.php">货币管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="config.php">通知配置</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">退出登录</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="bi bi-bell"></i> 通知配置管理
                            </h5>
                        </div>
                        <div class="card-body">
                            <form id="configForm">
                                <!-- Telegram 配置 -->
                                <div class="card mb-4">
                                    <div class="card-header bg-primary text-white">
                                        <h6 class="mb-0">
                                            <i class="bi bi-telegram"></i> Telegram 通知设置
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="telegramBotToken" class="form-label">Bot Token</label>
                                                    <input type="text" class="form-control" id="telegramBotToken" name="telegram_bot_token" placeholder="请输入Telegram Bot Token">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="telegramChatId" class="form-label">Chat ID</label>
                                                    <input type="text" class="form-control" id="telegramChatId" name="telegram_chat_id" placeholder="请输入Chat ID">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="mb-3">
                                                    <label for="telegramProxy" class="form-label">代理地址 <small class="text-muted">(可选)</small></label>
                                                    <input type="text" class="form-control" id="telegramProxy" name="telegram_proxy" placeholder="例如：https://api.fuckjd.de">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">&nbsp;</label>
                                                    <div>
                                                        <button type="button" class="btn btn-outline-primary" onclick="testTelegram()">
                                                            <i class="bi bi-send"></i> 测试连接
                                                        </button>
                                                        <span id="telegramTestResult" class="ms-2"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Ntfy 配置 -->
                                <div class="card mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h6 class="mb-0">
                                            <i class="bi bi-bell-fill"></i> Ntfy 通知设置
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="ntfyServer" class="form-label">服务器地址</label>
                                                    <input type="text" class="form-control" id="ntfyServer" name="ntfy_server" placeholder="例如：https://ntfy.sh">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="ntfyTopic" class="form-label">Topic</label>
                                                    <input type="text" class="form-control" id="ntfyTopic" name="ntfy_topic" placeholder="请输入Topic名称">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-8"></div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <button type="button" class="btn btn-outline-success" onclick="testNtfy()">
                                                        <i class="bi bi-send"></i> 测试连接
                                                    </button>
                                                    <span id="ntfyTestResult" class="ms-2"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bark 配置 -->
                                <div class="card mb-4">
                                    <div class="card-header bg-warning text-dark">
                                        <h6 class="mb-0">
                                            <i class="bi bi-phone"></i> Bark 通知设置
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="barkServer" class="form-label">服务器地址</label>
                                                    <input type="text" class="form-control" id="barkServer" name="bark_server" placeholder="例如：https://api.day.app">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label for="barkDeviceKey" class="form-label">Device Key</label>
                                                    <input type="text" class="form-control" id="barkDeviceKey" name="bark_device_key" placeholder="请输入Device Key">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-8"></div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <button type="button" class="btn btn-outline-warning" onclick="testBark()">
                                                        <i class="bi bi-send"></i> 测试连接
                                                    </button>
                                                    <span id="barkTestResult" class="ms-2"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- 保存按钮 -->
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="bi bi-save"></i> 保存配置
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- 提示消息模态框 -->
    <div class="modal fade" id="messageModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="messageModalTitle">提示</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="messageModalBody">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">关闭</button>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script>
        // 页面加载时获取配置
        document.addEventListener('DOMContentLoaded', function() {
            loadConfig();
        });

        // 加载配置
        function loadConfig() {
            fetch('api.php?action=get_config')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const config = data.config;
                        // 填充表单
                        document.getElementById('telegramBotToken').value = config.telegram_bot_token || '';
                        document.getElementById('telegramChatId').value = config.telegram_chat_id || '';
                        document.getElementById('telegramProxy').value = config.telegram_proxy || '';
                        document.getElementById('ntfyServer').value = config.ntfy_server || '';
                        document.getElementById('ntfyTopic').value = config.ntfy_topic || '';
                        document.getElementById('barkServer').value = config.bark_server || '';
                        document.getElementById('barkDeviceKey').value = config.bark_device_key || '';
                    }
                })
                .catch(error => {
                    console.error('加载配置失败:', error);
                });
        }

        // 保存配置
        document.getElementById('configForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const config = {};
            for (let [key, value] of formData.entries()) {
                config[key] = value;
            }

            fetch('api.php?action=save_config', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(config)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showMessage('成功', '配置保存成功！', 'success');
                } else {
                    showMessage('错误', data.message || '保存配置失败', 'danger');
                }
            })
            .catch(error => {
                console.error('保存配置失败:', error);
                showMessage('错误', '保存配置失败，请重试', 'danger');
            });
        });

        // 测试 Telegram
        function testTelegram() {
            const botToken = document.getElementById('telegramBotToken').value;
            const chatId = document.getElementById('telegramChatId').value;
            const proxy = document.getElementById('telegramProxy').value;

            if (!botToken || !chatId) {
                showMessage('错误', '请先填写Bot Token和Chat ID', 'warning');
                return;
            }

            const resultSpan = document.getElementById('telegramTestResult');
            resultSpan.innerHTML = '<span class="text-info"><i class="bi bi-hourglass-split"></i> 测试中...</span>';

            fetch('api.php?action=test_telegram', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    bot_token: botToken,
                    chat_id: chatId,
                    proxy: proxy
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    resultSpan.innerHTML = '<span class="text-success"><i class="bi bi-check-circle"></i> 测试成功</span>';
                } else {
                    resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                    showMessage('测试失败', data.message || '请检查配置', 'danger');
                }
            })
            .catch(error => {
                resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                showMessage('测试失败', '网络错误，请重试', 'danger');
            });
        }

        // 测试 Ntfy
        function testNtfy() {
            const server = document.getElementById('ntfyServer').value;
            const topic = document.getElementById('ntfyTopic').value;

            if (!server || !topic) {
                showMessage('错误', '请先填写服务器地址和Topic', 'warning');
                return;
            }

            const resultSpan = document.getElementById('ntfyTestResult');
            resultSpan.innerHTML = '<span class="text-info"><i class="bi bi-hourglass-split"></i> 测试中...</span>';

            fetch('api.php?action=test_ntfy', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    server: server,
                    topic: topic
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    resultSpan.innerHTML = '<span class="text-success"><i class="bi bi-check-circle"></i> 测试成功</span>';
                } else {
                    resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                    showMessage('测试失败', data.message || '请检查配置', 'danger');
                }
            })
            .catch(error => {
                resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                showMessage('测试失败', '网络错误，请重试', 'danger');
            });
        }

        // 测试 Bark
        function testBark() {
            const server = document.getElementById('barkServer').value;
            const deviceKey = document.getElementById('barkDeviceKey').value;

            if (!server || !deviceKey) {
                showMessage('错误', '请先填写服务器地址和Device Key', 'warning');
                return;
            }

            const resultSpan = document.getElementById('barkTestResult');
            resultSpan.innerHTML = '<span class="text-info"><i class="bi bi-hourglass-split"></i> 测试中...</span>';

            fetch('api.php?action=test_bark', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    server: server,
                    device_key: deviceKey
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    resultSpan.innerHTML = '<span class="text-success"><i class="bi bi-check-circle"></i> 测试成功</span>';
                } else {
                    resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                    showMessage('测试失败', data.message || '请检查配置', 'danger');
                }
            })
            .catch(error => {
                resultSpan.innerHTML = '<span class="text-danger"><i class="bi bi-x-circle"></i> 测试失败</span>';
                showMessage('测试失败', '网络错误，请重试', 'danger');
            });
        }

        // 显示消息
        function showMessage(title, message, type) {
            document.getElementById('messageModalTitle').textContent = title;
            document.getElementById('messageModalBody').innerHTML = `<div class="alert alert-${type}">${message}</div>`;
            new bootstrap.Modal(document.getElementById('messageModal')).show();
        }
    </script>
</body>
</html>