# VPS服务器到期通知功能使用说明

本文档介绍如何使用VPS服务器到期通知功能，该功能可以在服务器即将到期时自动发送提醒通知。

## 功能概述

通知系统会自动检查所有服务器的到期日期，并在以下时间点发送提醒：
- 到期前30天
- 到期前15天
- 到期前7天
- 到期前3天
- 到期前1天
- 服务器已过期时

通知会通过您在"通知配置"页面设置的渠道（Telegram、Ntfy、Bark）发送。

## 文件说明

- `notify.php`: 核心通知脚本，负责检查服务器到期时间并发送通知
- `setup_cron.php`: 帮助设置定时任务的脚本
- `data/config.json`: 存储通知渠道配置的文件
- `data/notification_log.txt`: 通知日志文件
- `data/cron_log.txt`: 定时任务执行日志文件

## 设置步骤

### 1. 配置通知渠道

1. 登录系统后，点击导航栏中的"通知配置"
2. 填写您想使用的通知渠道信息（Telegram、Ntfy、Bark）
3. 使用"测试连接"按钮确保配置正确
4. 点击"保存配置"按钮保存设置

### 2. 设置定时任务

方法一：使用辅助脚本（推荐）

1. 在服务器终端中，进入网站根目录
2. 运行以下命令：
   ```
   php setup_cron.php
   ```
3. 按照提示操作，选择"y"可以自动设置定时任务

方法二：手动设置

1. 在服务器终端中运行：
   ```
   crontab -e
   ```
2. 添加以下行（替换路径为您的实际路径）：
   ```
   0 9 * * * php /path/to/your/website/notify.php >> /path/to/your/website/data/cron_log.txt 2>&1
   ```
3. 保存并退出编辑器

## 手动测试

您可以随时手动运行通知脚本来测试功能：

```
php notify.php
```

如果有即将到期的服务器，脚本将立即发送通知。

## 自定义设置

### 修改提醒时间

通知系统已配置为：
- **到期前10天开始每天提醒**：从服务器到期前10天开始，每天都会发送提醒通知
- **过期后5天内继续提醒**：考虑到大部分服务商都有5天宽限期，系统会在服务器过期后的5天内继续发送提醒

如果您想调整这些设置，可以编辑`notify.php`文件中的以下部分：

```php
// 到期前10天开始每天提醒
if ($daysLeft <= 10) {
    // 可以修改10为其他天数
}

// 只在过期后5天内提醒
if ($daysOverdue <= 5) {
    // 可以修改5为其他天数
}
```

### 修改定时任务执行时间

默认情况下，通知脚本每天早上9点运行。如果您想更改这个时间，可以修改cron表达式：

- 每天早上8点运行：`0 8 * * *`
- 每天晚上10点运行：`0 22 * * *`
- 每天早上9点和下午3点运行：`0 9,15 * * *`

## 故障排除

如果通知未正常发送，请检查：

1. 通知配置是否正确（在"通知配置"页面测试连接）
2. 定时任务是否正确设置（运行`crontab -l`查看）
3. 查看日志文件：
   - `data/notification_log.txt`: 通知脚本日志
   - `data/cron_log.txt`: 定时任务执行日志

## 注意事项

- 确保服务器时区设置正确，否则可能影响通知时间
- 确保PHP有足够的权限访问和写入数据文件
- 如果更改了网站目录结构，需要相应更新cron任务中的路径