# VPS服务器管理系统

一个基于PHP的VPS服务器管理和统计系统，支持本地数据存储和实时汇率转换。

## 功能特性

- ✅ 服务器信息管理（添加、编辑、删除）
- ✅ 多币种支持和实时汇率转换
- ✅ 到期时间提醒和状态监控
- ✅ 美观的响应式界面设计
- ✅ 本地JSON文件数据存储
- ✅ 用户登录认证保护
- ✅ 完全本地化的CSS和JS资源

## 系统要求

- PHP 7.4 或更高版本
- Web服务器（Apache/Nginx/PHP内置服务器）
- 支持文件写入权限

## 安装说明

1. 将所有文件上传到Web服务器目录
2. 确保`data/`目录有写入权限
3. 访问系统首页，系统会自动重定向到登录页面

## 登录信息

- **用户名**: `tan`
- **密码**: `ng057720`

## 服务器信息字段

- **服务器名称**: 自定义的服务器标识名称
- **服务商**: VPS提供商名称
- **费用**: 服务器费用金额
- **币种**: 支持USD、CNY、EUR、GBP、JPY等多种货币
- **入手时间**: 购买服务器的日期
- **到期时间**: 服务器到期日期
- **备注**: 购买地址或管理地址等备注信息

## 汇率功能

系统集成了实时汇率API，自动将不同币种的费用转换为人民币显示，汇率数据每小时更新一次。

## 状态提醒

- 🟢 **正常**: 距离到期超过30天
- 🟡 **即将到期**: 距离到期7-30天
- 🔴 **紧急**: 距离到期少于7天
- ⚫ **已过期**: 已超过到期时间

## 文件结构

```
├── index.php          # 主页面
├── login.php          # 登录页面
├── logout.php         # 退出登录
├── api.php            # API接口
├── assets/
│   ├── css/
│   │   ├── bootstrap.min.css
│   │   ├── style.css
│   │   └── login.css
│   └── js/
│       ├── bootstrap.bundle.min.js
│       └── app.js
├── data/
│   ├── servers.json   # 服务器数据文件
│   └── exchange_rates.json # 汇率缓存文件
└── README.md
```

## 使用说明

1. **登录系统**: 使用提供的用户名和密码登录
2. **添加服务器**: 点击"添加服务器"按钮，填写服务器信息
3. **管理服务器**: 在服务器列表中可以编辑或删除服务器
4. **查看统计**: 系统自动计算总费用和到期提醒
5. **汇率转换**: 系统自动将所有费用转换为人民币显示

## 安全特性

- 会话管理和登录验证
- XSS防护（HTML转义）
- 本地数据存储，无外部数据库依赖
- 文件权限控制

## 技术栈

- **后端**: PHP 8.2
- **前端**: HTML5, CSS3, JavaScript (ES6+)
- **UI框架**: Bootstrap 5.3
- **数据存储**: JSON文件
- **汇率API**: ExchangeRate-API

## 开发者信息

本系统为VPS服务器管理专用工具，支持多币种和实时汇率转换，界面美观且功能完整。

---

© 2024 VPS管理系统