<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VPS服务器续期管理系统</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
</head>
<body>
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center" href="index.php">
                    <img src="assets/images/logo.svg" alt="Logo" width="32" height="32" class="me-2">
                    VPS服务器续期管理系统
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link active" href="index.php">服务器管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="providers.php">服务商管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">分类管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="currencies.php">货币管理</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="logout.php">退出登录</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>

        <div class="container mt-4">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">服务器列表</h5>
                                <div class="d-flex align-items-center">
                                        <button type="button" class="btn btn-outline-secondary btn-sm me-2" onclick="sortByExpiry()" title="按到期时间排序">
                                            <i class="bi bi-calendar-event"></i> 到期时间
                                        </button>
                                        <select id="categoryFilter" class="form-select form-select-sm me-2" onchange="filterByCategory()">
                                            <option value="">所有分类</option>
                                        </select>
                                        <select id="statusFilter" class="form-select form-select-sm me-2" onchange="filterByStatus()">
                                            <option value="">所有状态</option>
                                            <option value="active">活跃</option>
                                            <option value="archived">已归档</option>
                                        </select>
                                        <button type="button" class="btn btn-primary btn-sm me-2" id="addServerBtn">添加服务器</button>
                                        <button type="button" class="btn btn-info btn-sm" onclick="showArchivedServers()">查看归档</button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="serverList">
                                <!-- 服务器列表将在这里动态加载 -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- 添加/编辑服务器模态框 -->
    <div class="modal fade" id="serverModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">添加服务器</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="serverForm">
                        <input type="hidden" id="serverId" name="serverId">
                        <div class="mb-3">
                            <label for="serverName" class="form-label">服务器所在位置</label>
                            <input type="text" class="form-control" id="serverName" name="serverName" required placeholder="例如：美国洛杉矶、香港、新加坡等">
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="provider" class="form-label">服务商</label>
                                    <select class="form-select" id="provider" name="provider" required>
                                        <option value="">请选择服务商</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">分类 <small class="text-muted">(可多选)</small></label>
                                    <div id="categoriesCheckboxes" class="border rounded p-2" style="max-height: 120px; overflow-y: auto;">
                                        <!-- 分类复选框将通过JavaScript动态加载 -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="cost" class="form-label">费用</label>
                                    <input type="number" step="0.01" class="form-control" id="cost" name="cost" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="currency" class="form-label">币种</label>
                                    <select class="form-select" id="currency" name="currency" required>
                                        <option value="USD">美元 (USD)</option>
                                        <option value="CNY">人民币 (CNY)</option>
                                        <option value="EUR">欧元 (EUR)</option>
                                        <option value="GBP">英镑 (GBP)</option>
                                        <option value="JPY">日元 (JPY)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="purchaseDate" class="form-label">入手时间</label>
                                    <input type="date" class="form-control" id="purchaseDate" name="purchaseDate" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="expireDate" class="form-label">到期时间</label>
                                    <input type="date" class="form-control" id="expireDate" name="expireDate" required>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="renewStatus" class="form-label">续期状态</label>
                            <select class="form-select" id="renewStatus" name="renewStatus" required>
                                <option value="active">继续使用</option>
                                <option value="archived">不再续期</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="autoRenew" name="autoRenew">
                                <label class="form-check-label" for="autoRenew">
                                    自动续期
                                </label>
                            </div>
                            <small class="form-text text-muted">开启后，服务器将在到期时自动根据续费周期延长</small>
                        </div>
                        <div class="mb-3" id="renewCycleGroup" style="display: none;">
                            <label for="renewCycle" class="form-label">续费周期</label>
                            <select class="form-select" id="renewCycle" name="renewCycle">
                                <option value="30">月付 (30天)</option>
                                <option value="90">季付 (90天)</option>
                                <option value="180">半年付 (180天)</option>
                                <option value="365">年付 (365天)</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="panelAccount" class="form-label">面板账号</label>
                                    <input type="text" class="form-control" id="panelAccount" name="panelAccount">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="panelPassword" class="form-label">面板密码</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="panelPassword" name="panelPassword">
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePasswordVisibility('panelPassword')"><i class="bi bi-eye"></i></button>
                                        <button class="btn btn-outline-secondary" type="button" onclick="copyPassword('panelPassword')"><i class="bi bi-clipboard"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="notes" class="form-label">备注（购买地址或管理地址）</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary" form="serverForm">保存</button>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js"></script>
    <!-- Matomo -->
<script>
  var _paq = window._paq = window._paq || [];
  /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
  _paq.push(['trackPageView']);
  _paq.push(['enableLinkTracking']);
  (function() {
    var u="//count.fuckj.de/";
    _paq.push(['setTrackerUrl', u+'matomo.php']);
    _paq.push(['setSiteId', '1']);
    var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
    g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
  })();
</script>
<!-- End Matomo Code -->

</body>
</html>