// 统一的API配置
export const getApiBaseUrl = () => {
  // 在开发环境下使用localhost
  if (process.env.NODE_ENV === 'development') {
    return 'http://localhost:3005/api';
  }
  
  // 在生产环境下，根据当前访问的域名/IP动态设置API地址
  const currentHost = window.location.hostname;
  const currentProtocol = window.location.protocol;
  
  // 如果是通过域名cfdns.023021.xyz访问（前端反代），后端使用cfdnsback.023021.xyz
  if (currentHost === 'cfdns.023021.xyz') {
    return 'http://cfdnsback.023021.xyz:3005/api';
  }
  
  // 其他所有访问方式（localhost、IP访问等）都使用localhost
  return 'http://localhost:3005/api';
};

export const API_BASE_URL = getApiBaseUrl();