<?php include 'auth.php'; ?>
<?php
$usersFile = __DIR__ . '/users.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];
    $users[] = ['name' => $name, 'email' => $email];
    file_put_contents($usersFile, json_encode($users, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    header("Location: users.php");
    exit;
}

if (isset($_GET['delete'])) {
    $index = intval($_GET['delete']);
    $users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];
    if (isset($users[$index])) {
        unset($users[$index]);
        file_put_contents($usersFile, json_encode(array_values($users), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    }
    header("Location: users.php");
    exit;
}

$users = file_exists($usersFile) ? json_decode(file_get_contents($usersFile), true) : [];

// 分页逻辑
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$per_page = 20;
$total_records = count($users);
$total_pages = ceil($total_records / $per_page);
$offset = ($page - 1) * $per_page;

// 获取当前页的数据
$users_paged = array_slice($users, $offset, $per_page, true);
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
  <meta charset="UTF-8">
  <title>用户管理</title>
  <link rel="icon" type="image/svg+xml" href="favicon.svg">
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">账单管理系统</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="index.php">➕ 创建账单</a></li>
        <li class="nav-item"><a class="nav-link" href="bill_manager.php">📂 账单管理</a></li>
        <li class="nav-item"><a class="nav-link active" href="users.php">👥 用户管理</a></li>
      </ul>
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link text-danger" href="logout.php">🚪 退出登录</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container">
  <div class="card p-4 mb-4 shadow">
    <h4 class="mb-3">📥 添加新用户</h4>
    <form method="post">
      <div class="mb-3">
        <label class="form-label">用户名</label>
        <input type="text" name="name" class="form-control" required>
      </div>
      <div class="mb-3">
        <label class="form-label">邮箱地址</label>
        <input type="email" name="email" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-success">✅ 添加用户</button>
    </form>
  </div>

  <div class="card p-4 shadow">
    <h4 class="mb-3">👥 当前用户列表 (共 <?= $total_records ?> 条记录，第 <?= $page ?>/<?= $total_pages ?> 页)</h4>
    
    <?php if ($total_pages > 1): ?>
    <nav aria-label="用户分页">
      <ul class="pagination justify-content-center mb-3">
        <?php if ($page > 1): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= $page - 1 ?>">上一页</a>
          </li>
        <?php endif; ?>
        
        <?php
        $start_page = max(1, $page - 2);
        $end_page = min($total_pages, $page + 2);
        
        if ($start_page > 1): ?>
          <li class="page-item"><a class="page-link" href="?page=1">1</a></li>
          <?php if ($start_page > 2): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
        <?php endif; ?>
        
        <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
          <li class="page-item <?= $i == $page ? 'active' : '' ?>">
            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
          </li>
        <?php endfor; ?>
        
        <?php if ($end_page < $total_pages): ?>
          <?php if ($end_page < $total_pages - 1): ?>
            <li class="page-item disabled"><span class="page-link">...</span></li>
          <?php endif; ?>
          <li class="page-item"><a class="page-link" href="?page=<?= $total_pages ?>"><?= $total_pages ?></a></li>
        <?php endif; ?>
        
        <?php if ($page < $total_pages): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= $page + 1 ?>">下一页</a>
          </li>
        <?php endif; ?>
      </ul>
    </nav>
    <?php endif; ?>
    
    <table class="table table-bordered">
      <thead>
        <tr>
          <th>用户名</th>
          <th>邮箱</th>
          <th>操作</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users_paged as $i => $user): ?>
        <tr>
          <td><?= htmlspecialchars($user['name']) ?></td>
          <td><?= htmlspecialchars($user['email']) ?></td>
          <td><a href="users.php?delete=<?= $offset + $i ?>" class="btn btn-sm btn-danger" onclick="return confirm('确定删除该用户？')">删除</a></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
