<?php
include 'auth.php';

$invoice = $_GET['invoice'] ?? '';
$invoice = preg_replace('/[^a-zA-Z0-9_-]/', '', $invoice);
if (!$invoice) {
  http_response_code(400);
  exit('参数缺失');
}

$meta_file = __DIR__ . '/invoices/meta.json';
$meta = file_exists($meta_file) ? json_decode(file_get_contents($meta_file), true) : [];

if (!isset($meta[$invoice])) {
  http_response_code(404);
  exit('账单不存在');
}

$pdf_path = __DIR__ . "/invoices/Invoice-$invoice.pdf";
if (file_exists($pdf_path)) unlink($pdf_path);

unset($meta[$invoice]);
file_put_contents($meta_file, json_encode($meta, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

echo 'ok';
