<?php
session_start();

// 配置
define('DATA_DIR', __DIR__ . '/data');
define('ADMIN_FILE', DATA_DIR . '/admins.json');

// 包含功能函数
include 'functions.php';

// 创建数据目录
if (!is_dir(DATA_DIR)) {
    mkdir(DATA_DIR, 0755, true);
}

// 初始化管理员账号
if (!file_exists(ADMIN_FILE)) {
    $admins = [
        'tan' => [
            'password' => password_hash('ng057720', PASSWORD_DEFAULT),
            'created_at' => date('Y-m-d H:i:s')
        ]
    ];
    file_put_contents(ADMIN_FILE, json_encode($admins, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// 获取当前页面
$page = $_GET['page'] ?? 'home';
$action = $_POST['action'] ?? $_GET['action'] ?? '';

// 处理AJAX请求
if ($action) {
    header('Content-Type: application/json');
    
    switch ($action) {
        case 'login':
            handleLogin();
            break;
        case 'logout':
            handleLogout();
            break;
        case 'check_login':
            handleCheckLogin();
            break;
        case 'search':
            handleSearch();
            break;
        case 'add':
            handleAdd();
            break;
        case 'delete':
            handleDelete();
            break;
        case 'permanent_delete':
            handlePermanentDelete();
            break;
        case 'export':
            handleExport();
            break;
        case 'get_floors':
            handleGetFloors();
            break;
        case 'get_accounts':
            handleGetAccounts();
            break;
        case 'change_password':
            handleChangePassword();
            break;
        case 'add_admin':
            handleAddAdmin();
            break;
        case 'get_merchants':
            handleGetMerchants();
            break;
        case 'get_categories':
            handleGetCategories();
            break;
        case 'get_floor_config':
            handleGetFloorConfig();
            break;
        case 'add_merchant':
            handleAddMerchant();
            break;
        case 'add_category':
            handleAddCategory();
            break;
        case 'add_floor_config':
            handleAddFloorConfig();
            break;
        case 'delete_merchant':
            handleDeleteMerchant();
            break;
        case 'delete_category':
            handleDeleteCategory();
            break;
        case 'delete_floor_config':
            handleDeleteFloorConfig();
            break;
        case 'edit_merchant':
            handleEditMerchant();
            break;
        case 'edit_category':
            handleEditCategory();
            break;
        case 'edit_floor_config':
            handleEditFloorConfig();
            break;
        case 'editSubAccount':
            handleEditSubAccount();
            break;
        case 'get_admins':
            handleGetAdmins();
            break;
        case 'delete_admin':
            handleDeleteAdmin();
            break;
        case 'toggle_admin':
            handleToggleAdmin();
            break;
        default:
            echo json_encode(['success' => false, 'message' => '未知操作']);
    }
    exit;
}

?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>美团账号管理系统</title>
    <link rel="icon" type="image/svg+xml" href="assets/favicon.svg">
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <div class="container">
        <header class="header">
            <h1>美团账号管理系统</h1>
            <div class="user-info">
                <?php if (isset($_SESSION['admin'])): ?>
                    <span>欢迎，<?php echo htmlspecialchars($_SESSION['admin']); ?></span>
                    <button onclick="logout()" class="btn btn-secondary">退出</button>
                    <button onclick="showAdminPanel()" class="btn btn-primary">管理员设置</button>
                    <a href="merchants.php" class="btn btn-info">商户管理</a>
                    <a href="categories.php" class="btn btn-info">分类管理</a>
                    <a href="floors.php" class="btn btn-info">楼层管理</a>
                <?php else: ?>
                    <button onclick="showLogin()" class="btn btn-primary">管理员登录</button>
                <?php endif; ?>
            </div>
        </header>

        <main class="main">
            <div class="search-section">
                <div class="search-box">
                    <div class="search-left">
                        <div id="merchantSearchContainer" class="merchant-search-container">
                            <input type="text" id="merchantSearchInput" class="search-input" placeholder="输入商户名称..." 
                                   oninput="onMerchantSearchInput()" onblur="hideMerchantSearchSuggestions()">
                            <div id="merchantSearchSuggestions" class="suggestions-dropdown"></div>
                        </div>
                        <select id="floorFilter" class="search-select">
                            <option value="">全部楼层</option>
                        </select>
                        <button onclick="performSearch()" class="btn btn-primary">搜索</button>
                        <button onclick="clearSearch()" class="btn btn-secondary">清空</button>
                    </div>
                    <?php if (isset($_SESSION['admin'])): ?>
                    <div class="search-right">
                        <button onclick="showAddForm()" class="btn btn-success">新增账号</button>
                        <button onclick="importData()" class="btn btn-warning">导入Excel</button>
                        <button onclick="exportData()" class="btn btn-info">导出Excel</button>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="table-container">
                <table class="data-table" id="dataTable">
                    <thead id="tableHeader">
                        <tr>
                            <th>序号</th>
                            <th>商户名称 <span class="sort-icon" onclick="sortTable('merchant_name')" title="点击排序">⇅</span></th>
                            <th>商户分类</th>
                            <th>账号</th>
                            <th>手机号</th>
                            <th>楼层 <span class="sort-icon" onclick="sortTable('floor')" title="点击排序">⇅</span></th>
                            <th>备注</th>
                            <th>状态</th>
                            <th>操作时间</th>
                            <?php if (isset($_SESSION['admin'])): ?>
                                <th>操作</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody id="tableBody">
                        <!-- 数据将通过JavaScript动态加载 -->
                    </tbody>
                </table>
            </div>
        </main>

        <!-- 登录模态框 -->
        <div id="loginModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('loginModal')">&times;</span>
                <h2>管理员登录</h2>
                <form id="loginForm">
                    <div class="form-group">
                        <label for="username">用户名:</label>
                        <input type="text" id="username" name="username" required>
                    </div>
                    <div class="form-group">
                        <label for="password">密码:</label>
                        <input type="password" id="password" name="password" required>
                    </div>
                    <button type="submit" class="btn btn-primary">登录</button>
                </form>
            </div>
        </div>

        <!-- 添加账号模态框 -->
        <div id="addModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('addModal')">&times;</span>
                <h2>新增账号</h2>
                <form id="addForm">
                    <div class="form-group">
                        <label for="merchant_name">商户名称:</label>
                        <div class="autocomplete-container">
                            <input type="text" id="merchant_name" name="merchant_name" required 
                                   placeholder="输入商户名称或选择已有商户" 
                                   oninput="onMerchantInput()" 
                                   onfocus="showMerchantSuggestions()" 
                                   onblur="hideMerchantSuggestions()">
                            <div id="merchant_suggestions" class="suggestions-dropdown"></div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="merchant_category">商户分类:</label>
                        <select id="merchant_category" name="merchant_category" required>
                            <option value="">请先选择商户</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="account">账号:</label>
                        <input type="text" id="account" name="account" required>
                    </div>
                    <div class="form-group">
                        <label for="phone">手机号:</label>
                        <input type="tel" id="phone" name="phone" required>
                    </div>
                    <div class="form-group">
                        <label for="floor">楼层:</label>
                        <select id="floor" name="floor" required>
                            <option value="">请选择楼层</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="remark">备注:</label>
                        <textarea id="remark" name="remark" rows="3"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">添加</button>
                </form>
            </div>
        </div>

        <!-- 管理员设置模态框 -->
        <div id="adminModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('adminModal')">&times;</span>
                <h2>管理员设置</h2>
                <div class="admin-section">
                    <h3>修改密码</h3>
                    <form id="changePasswordForm">
                        <div class="form-group">
                            <label>新密码:</label>
                            <input type="password" id="newPassword" required>
                        </div>
                        <div class="form-group">
                            <label>确认密码:</label>
                            <input type="password" id="confirmPassword" required>
                        </div>
                        <button type="submit" class="btn btn-primary">修改密码</button>
                    </form>
                </div>
                <div class="admin-section">
                    <h3>管理员列表</h3>
                    <div id="adminList" class="admin-list">
                        <!-- 管理员列表将在这里动态加载 -->
                    </div>
                </div>
                <div class="admin-section">
                    <h3>添加管理员</h3>
                    <form id="addAdminForm">
                        <div class="form-group">
                            <label>用户名:</label>
                            <input type="text" id="adminUsername" required>
                        </div>
                        <div class="form-group">
                            <label>密码:</label>
                            <input type="password" id="adminPassword" required>
                        </div>
                        <button type="submit" class="btn btn-success">添加管理员</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- 子账号管理模态框 -->
        <div id="subAccountModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('subAccountModal')">&times;</span>
                <h2 id="subAccountModalTitle">新增子账号</h2>
                <form id="subAccountForm">
                    <div class="form-group">
                        <label for="subUsername">用户名:</label>
                        <input type="text" id="subUsername" name="username" required>
                    </div>
                    <div class="form-group">
                        <label for="subPassword">密码:</label>
                        <input type="password" id="subPassword" name="password" required>
                    </div>
                    <div class="form-group">
                        <label for="subMerchant">关联商户:</label>
                        <select id="subMerchant" name="merchant_id" required>
                            <option value="">请选择商户</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="subCategoryDisplay">商户分类:</label>
                        <input type="text" id="subCategoryDisplay" readonly placeholder="选择商户后自动填充">
                        <input type="hidden" id="subCategoryId" name="category_id">
                    </div>
                    <div class="form-group">
                        <label for="subFloorDisplay">楼层:</label>
                        <input type="text" id="subFloorDisplay" readonly placeholder="选择商户后自动填充">
                        <input type="hidden" id="subFloorId" name="floor_id">
                    </div>
                    <div class="form-group">
                        <label for="subStatus">状态:</label>
                        <select id="subStatus" name="status">
                            <option value="active">启用</option>
                            <option value="inactive">禁用</option>
                            <option value="frozen">冻结</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">保存</button>
                </form>
            </div>
        </div>

        <!-- 子账号编辑模态框 -->
        <div id="editSubAccountModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeModal('editSubAccountModal')">&times;</span>
                <h2>编辑子账号</h2>
                <form id="editSubAccountForm">
                    <input type="hidden" id="editSubAccountId" name="id">
                    <div class="form-group">
                        <label for="editSubUsername">用户名:</label>
                        <input type="text" id="editSubUsername" name="username" required>
                    </div>
                    <div class="form-group">
                        <label for="editSubPassword">密码:</label>
                        <input type="password" id="editSubPassword" name="password" placeholder="留空则不修改密码">
                    </div>
                    <div class="form-group">
                        <label for="editSubMerchant">关联商户:</label>
                        <select id="editSubMerchant" name="merchant_id" required>
                            <option value="">请选择商户</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editSubCategoryDisplay">商户分类:</label>
                        <input type="text" id="editSubCategoryDisplay" readonly placeholder="选择商户后自动填充">
                        <input type="hidden" id="editSubCategoryId" name="category_id">
                    </div>
                    <div class="form-group">
                        <label for="editSubFloorDisplay">楼层:</label>
                        <input type="text" id="editSubFloorDisplay" readonly placeholder="选择商户后自动填充">
                        <input type="hidden" id="editSubFloorId" name="floor_id">
                    </div>
                    <div class="form-group">
                        <label for="editSubStatus">状态:</label>
                        <select id="editSubStatus" name="status">
                            <option value="active">启用</option>
                            <option value="inactive">禁用</option>
                            <option value="frozen">冻结</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">保存修改</button>
                </form>
            </div>
        </div>

        <script src="assets/script.js"></script>
    </div>
</body>
</html>