<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>楼层管理 - 美团子账号管理系统</title>
    <link rel="icon" type="image/svg+xml" href="assets/favicon.svg">
    <link rel="stylesheet" href="assets/style.css">
    <style>
        .floor-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        
        .page-title {
            font-size: 24px;
            font-weight: 600;
            color: #333;
            margin: 0;
        }
        
        .nav-menu {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        
        .nav-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            transition: background-color 0.2s;
        }
        
        .nav-btn:hover {
            background: #0056b3;
        }
        
        .nav-btn.active {
            background: #28a745;
        }
        
        .back-btn {
            background: #6c757d;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            transition: background-color 0.2s;
        }
        
        .back-btn:hover {
            background: #5a6268;
        }
        
        .floor-section {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .section-header {
            background: #f8f9fa;
            padding: 20px;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin: 0;
        }
        
        .add-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s;
        }
        
        .add-btn:hover {
            background: #0056b3;
        }
        
        .floor-list {
            padding: 20px;
        }
        
        .floor-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        
        .floor-item:last-child {
            border-bottom: none;
        }
        
        .floor-item-info {
            flex: 1;
        }
        
        .floor-item-name {
            font-size: 16px;
            font-weight: 500;
            color: #333;
            margin-bottom: 5px;
        }
        
        .floor-item-time {
            font-size: 12px;
            color: #666;
        }
        
        .floor-item-actions {
            display: flex;
            gap: 8px;
        }
        
        .edit-btn {
            background: #28a745;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background-color 0.2s;
        }
        
        .edit-btn:hover {
            background: #218838;
        }
        
        .delete-btn {
            background: #dc3545;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            transition: background-color 0.2s;
        }
        
        .delete-btn:hover {
            background: #c82333;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #666;
        }
        
        .empty-state img {
            width: 80px;
            height: 80px;
            margin-bottom: 16px;
            opacity: 0.5;
        }
        
        /* 模态框样式 */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            animation: fadeIn 0.3s ease;
        }
        
        .modal-content {
            background-color: white;
            margin: 10% auto;
            padding: 0;
            border-radius: 8px;
            width: 500px;
            max-width: 90%;
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
            animation: slideIn 0.3s ease;
        }
        
        .modal-header {
            padding: 20px;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .modal-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin: 0;
        }
        
        .close {
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #666;
            padding: 0;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .close:hover {
            color: #333;
        }
        
        .modal-body {
            padding: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #333;
        }
        
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #007bff;
            box-shadow: 0 0 0 2px rgba(0,123,255,0.25);
        }
        
        .modal-footer {
            padding: 20px;
            border-top: 1px solid #e9ecef;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.2s;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-primary:hover {
            background: #0056b3;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideIn {
            from { transform: translateY(-50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
    </style>
</head>
<body>
    <div class="floor-container">
        <div class="page-header">
            <h1 class="page-title">楼层管理</h1>
            <div class="nav-menu">
                <a href="merchants.php" class="nav-btn">商户管理</a>
                <a href="categories.php" class="nav-btn">分类管理</a>
                <a href="floors.php" class="nav-btn active">楼层管理</a>
                <a href="index.php" class="back-btn">返回主页</a>
            </div>
        </div>
        
        <!-- 楼层管理 -->
        <div class="floor-section">
            <div class="section-header">
                <h2 class="section-title">楼层列表</h2>
                <button class="add-btn" onclick="openAddModal()">添加楼层</button>
            </div>
            <div class="floor-list" id="floorList">
                <div class="empty-state">
                    <img src="assets/empty-data.svg" alt="暂无数据">
                    <p>暂无楼层数据</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- 添加/编辑模态框 -->
    <div id="floorModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="modalTitle">添加楼层</h3>
                <button class="close" onclick="closeModal()">&times;</button>
            </div>
            <div class="modal-body">
                <form id="floorForm">
                    <div class="form-group">
                        <label for="floorName">楼层名称</label>
                        <input type="text" id="floorName" name="name" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" onclick="closeModal()">取消</button>
                <button type="button" class="btn btn-primary" onclick="saveFloor()">保存</button>
            </div>
        </div>
    </div>

    <!-- 消息提示弹窗 -->
    <div id="messageModal" class="message-modal">
        <div class="message-modal-content">
            <div class="message-modal-header">
                <h3 id="messageTitle">提示</h3>
                <button class="message-close" onclick="closeMessageModal()">&times;</button>
            </div>
            <div class="message-modal-body">
                <p id="messageText"></p>
            </div>
            <div class="message-modal-footer">
                <button class="btn btn-primary" onclick="closeMessageModal()">确定</button>
            </div>
        </div>
    </div>

    <!-- 确认对话框 -->
    <div id="confirmModal" class="message-modal">
        <div class="message-modal-content">
            <div class="message-modal-header">
                <h3>确认操作</h3>
                <button class="message-close" onclick="closeConfirmModal()">&times;</button>
            </div>
            <div class="message-modal-body">
                <p id="confirmText"></p>
            </div>
            <div class="message-modal-footer">
                <button class="btn btn-secondary" onclick="closeConfirmModal()">取消</button>
                <button class="btn btn-danger" onclick="confirmAction()">确定</button>
            </div>
        </div>
    </div>

    <style>
        .message-modal {
            display: none;
            position: fixed;
            z-index: 2000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.5);
            animation: fadeIn 0.3s ease;
        }
        
        .message-modal-content {
            background-color: white;
            margin: 15% auto;
            border-radius: 8px;
            width: 400px;
            max-width: 90%;
            box-shadow: 0 4px 20px rgba(0,0,0,0.15);
            animation: slideIn 0.3s ease;
        }
        
        .message-modal-header {
            padding: 20px 20px 10px;
            border-bottom: 1px solid #e9ecef;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .message-modal-header h3 {
            margin: 0;
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }
        
        .message-close {
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #666;
            padding: 0;
            width: 30px;
            height: 30px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .message-close:hover {
            color: #333;
        }
        
        .message-modal-body {
            padding: 20px;
        }
        
        .message-modal-body p {
            margin: 0;
            line-height: 1.5;
            color: #666;
        }
        
        .message-modal-footer {
            padding: 10px 20px 20px;
            display: flex;
            justify-content: flex-end;
            gap: 10px;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c82333;
        }
    </style>

    <script>
        let currentId = '';
        let isEditMode = false;
        let confirmCallback = null;

        // 消息提示函数
        function showMessage(message, type = 'info') {
            const modal = document.getElementById('messageModal');
            const title = document.getElementById('messageTitle');
            const text = document.getElementById('messageText');
            
            // 设置标题和图标
            switch(type) {
                case 'success':
                    title.textContent = '成功';
                    break;
                case 'error':
                    title.textContent = '错误';
                    break;
                case 'warning':
                    title.textContent = '警告';
                    break;
                default:
                    title.textContent = '提示';
            }
            
            text.textContent = message;
            modal.style.display = 'block';
        }

        // 关闭消息弹窗
        function closeMessageModal() {
            document.getElementById('messageModal').style.display = 'none';
        }

        // 确认对话框
        function showConfirm(message, callback) {
            const modal = document.getElementById('confirmModal');
            const text = document.getElementById('confirmText');
            
            text.textContent = message;
            confirmCallback = callback;
            modal.style.display = 'block';
        }

        // 关闭确认对话框
        function closeConfirmModal() {
            document.getElementById('confirmModal').style.display = 'none';
            confirmCallback = null;
        }

        // 执行确认操作
        function confirmAction() {
            if (confirmCallback) {
                confirmCallback();
            }
            closeConfirmModal();
        }
        
        // 页面加载时初始化数据
        document.addEventListener('DOMContentLoaded', function() {
            loadFloors();
        });
        
        // 加载楼层数据
        function loadFloors() {
            fetch('index.php?action=get_floor_config')
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                    }
                    return response.text();
                })
                .then(text => {
                    try {
                        const data = JSON.parse(text);
                        if (data.success && data.floors) {
                            renderFloorList(data.floors);
                        } else {
                            renderFloorList([]);
                            showMessage('暂无楼层数据', 'info');
                        }
                    } catch (e) {
                        console.error('JSON解析错误:', e);
                        console.error('服务器响应:', text);
                        renderFloorList([]);
                        showMessage('加载楼层数据失败，服务器响应格式错误', 'error');
                    }
                })
                .catch(error => {
                    console.error('网络错误:', error);
                    renderFloorList([]);
                    showMessage(`加载楼层数据失败: ${error.message}`, 'error');
                });
        }
        
        // 渲染楼层列表
        function renderFloorList(floors) {
            const container = document.getElementById('floorList');
            
            if (floors.length === 0) {
                container.innerHTML = `
                    <div class="empty-state">
                        <img src="assets/empty-data.svg" alt="暂无数据">
                        <p>暂无楼层数据</p>
                    </div>
                `;
                return;
            }
            
            container.innerHTML = floors.map(floor => `
                <div class="floor-item">
                    <div class="floor-item-info">
                        <div class="floor-item-name">${floor.name}</div>
                        <div class="floor-item-time">创建时间: ${floor.created_at}</div>
                    </div>
                    <div class="floor-item-actions">
                        <button class="edit-btn" onclick="editFloor('${floor.id}', '${floor.name}')">编辑</button>
                        <button class="delete-btn" onclick="deleteFloor('${floor.id}', '${floor.name}')">删除</button>
                    </div>
                </div>
            `).join('');
        }
        
        // 打开添加模态框
        function openAddModal() {
            currentId = '';
            isEditMode = false;
            document.getElementById('modalTitle').textContent = '添加楼层';
            document.getElementById('floorName').value = '';
            document.getElementById('floorModal').style.display = 'block';
        }
        
        // 编辑楼层
        function editFloor(id, name) {
            currentId = id;
            isEditMode = true;
            document.getElementById('modalTitle').textContent = '编辑楼层';
            document.getElementById('floorName').value = name;
            document.getElementById('floorModal').style.display = 'block';
        }
        
        // 关闭模态框
        function closeModal() {
            document.getElementById('floorModal').style.display = 'none';
        }
        
        // 保存楼层
        function saveFloor() {
            const name = document.getElementById('floorName').value.trim();
            
            if (!name) {
                showMessage('请输入楼层名称', 'warning');
                return;
            }
            
            const formData = new FormData();
            formData.append('name', name);
            
            if (isEditMode) {
                formData.append('action', 'edit_floor_config');
                formData.append('id', currentId);
            } else {
                formData.append('action', 'add_floor_config');
            }
            
            fetch('index.php', {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                }
                return response.text();
            })
            .then(text => {
                try {
                    const data = JSON.parse(text);
                    if (data.success) {
                        closeModal();
                        loadFloors();
                        showMessage(isEditMode ? '楼层更新成功！' : '楼层添加成功！', 'success');
                    } else {
                        showMessage(data.message || '操作失败', 'error');
                    }
                } catch (e) {
                    console.error('JSON解析错误:', e);
                    console.error('服务器响应:', text);
                    showMessage('服务器响应格式错误，请检查后端配置', 'error');
                }
            })
            .catch(error => {
                console.error('网络错误:', error);
                showMessage(`网络请求失败: ${error.message}`, 'error');
            });
        }
        
        // 删除楼层
        function deleteFloor(id, name) {
            showConfirm(`确定要删除楼层"${name}"吗？`, function() {
                const formData = new FormData();
                formData.append('action', 'delete_floor_config');
                formData.append('id', id);
                
                fetch('index.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                    }
                    return response.text();
                })
                .then(text => {
                    try {
                        const data = JSON.parse(text);
                        if (data.success) {
                            loadFloors();
                            showMessage('楼层删除成功！', 'success');
                        } else {
                            showMessage(data.message || '删除失败', 'error');
                        }
                    } catch (e) {
                        console.error('JSON解析错误:', e);
                        console.error('服务器响应:', text);
                        showMessage('服务器响应格式错误，请检查后端配置', 'error');
                    }
                })
                .catch(error => {
                    console.error('网络错误:', error);
                    showMessage(`网络请求失败: ${error.message}`, 'error');
                });
            });
        }
        
        // 点击模态框外部关闭
        window.onclick = function(event) {
            const modal = document.getElementById('floorModal');
            if (event.target === modal) {
                closeModal();
            }
        }
        
        // 回车键保存
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Enter' && document.getElementById('floorModal').style.display === 'block') {
                saveFloor();
            }
        });
    </script>
</body>
</html>