<?php
$post = getPost($year, $month, $day, $slug);
if (!$post) {
    http_response_code(404);
    include '404.php';
    exit;
}

$comments = getComments($post['id']);
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($post['title'] ?? '动态详情'); ?> - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="post-detail">
            <div class="post-header">
                <img src="<?php echo getAvatarImage(); ?>" alt="头像" class="post-avatar">
                <div class="post-info">
                    <h3><?php echo DEFAULT_ADMIN_NICK; ?></h3>
                    <span class="post-time"><?php echo formatDate($post['created_at']); ?></span>
                </div>
            </div>
            
            <div class="post-content">
                <?php if (!empty($post['title'])): ?>
                <h2 class="post-title"><?php echo htmlspecialchars($post['title']); ?></h2>
                <?php endif; ?>
                <div><?php echo $post['content']; ?></div>
                <?php if (!empty($post['images'])): ?>
                <div class="post-images">
                    <?php foreach ($post['images'] as $image): ?>
                    <img src="<?php echo $image; ?>" alt="图片" class="post-image">
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- 评论区 -->
        <?php if (!isset($post['comments_enabled']) || $post['comments_enabled']): ?>
        <div class="comments-section">
            <h3>评论 (<?php echo count($comments); ?>)</h3>
            
            <!-- 评论表单 -->
            <div class="comment-form">
                <form id="commentForm" onsubmit="submitComment(event)">
                    <input type="hidden" name="post_id" value="<?php echo $post['id']; ?>">
                    <input type="text" name="nickname" placeholder="昵称" required>
                    <input type="email" name="email" placeholder="邮箱（用于验证）" required>
                    <div class="verification-section" style="display: none;">
                        <input type="text" name="verification_code" placeholder="验证码" maxlength="6">
                        <button type="button" onclick="sendVerificationCode()">发送验证码</button>
                    </div>
                    <textarea name="content" placeholder="写下你的评论..." required></textarea>
                    <button type="submit">发表评论</button>
                </form>
            </div>

            <!-- 评论列表 -->
            <div class="comments-list">
                <?php foreach ($comments as $comment): ?>
                <div class="comment-item">
                    <img src="/src/avatar.png" alt="头像" class="comment-avatar">
                    <div class="comment-content">
                        <div class="comment-header">
                            <span class="comment-nickname"><?php echo htmlspecialchars($comment['nickname']); ?></span>
                            <span class="comment-time"><?php echo formatDate($comment['created_at']); ?></span>
                        </div>
                        <p><?php echo nl2br(htmlspecialchars($comment['content'])); ?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php else: ?>
        <div class="comments-disabled">
            <div class="comments-disabled-content">
                <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="comments-disabled-icon">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                    <line x1="9" y1="9" x2="15" y2="15"/>
                    <line x1="15" y1="9" x2="9" y2="15"/>
                </svg>
                <p>此文章已关闭评论功能</p>
            </div>
        </div>
        <?php endif; ?>

        <div class="back-button">
            <a href="/">返回首页</a>
        </div>
    </div>

    <script src="/assets/js/main.js"></script>
</body>
</html>
