<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - 页面飞到外太空了</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #a8e6cf 0%, #88d8c0 25%, #78c2ad 50%, #68b69a 75%, #58aa87 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }
        
        /* 星空背景 */
        .stars {
            position: absolute;
            width: 100%;
            height: 100%;
            background: transparent;
        }
        
        .star {
            position: absolute;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            animation: twinkle 2s infinite alternate;
        }
        
        .star:nth-child(1) { width: 2px; height: 2px; top: 20%; left: 20%; animation-delay: 0s; }
        .star:nth-child(2) { width: 1px; height: 1px; top: 30%; left: 80%; animation-delay: 0.5s; }
        .star:nth-child(3) { width: 3px; height: 3px; top: 60%; left: 30%; animation-delay: 1s; }
        .star:nth-child(4) { width: 2px; height: 2px; top: 80%; left: 70%; animation-delay: 1.5s; }
        .star:nth-child(5) { width: 1px; height: 1px; top: 10%; left: 60%; animation-delay: 2s; }
        .star:nth-child(6) { width: 2px; height: 2px; top: 70%; left: 10%; animation-delay: 0.3s; }
        .star:nth-child(7) { width: 1px; height: 1px; top: 40%; left: 90%; animation-delay: 0.8s; }
        .star:nth-child(8) { width: 3px; height: 3px; top: 90%; left: 40%; animation-delay: 1.3s; }
        
        @keyframes twinkle {
            0% { opacity: 0.4; }
            100% { opacity: 1; }
        }
        
        /* 主容器 */
        .container {
            text-align: center;
            color: #2c3e50;
            z-index: 10;
            position: relative;
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            border-radius: 30px;
            padding: 60px 40px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }
        
        .error-code {
            font-size: 8rem;
            font-weight: bold;
            margin-bottom: 1rem;
            background: linear-gradient(45deg, #2c3e50, #34495e, #3498db);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        .error-title {
            font-size: 2rem;
            margin-bottom: 1rem;
            color: #2c3e50;
            font-weight: 600;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .error-message {
            font-size: 1.2rem;
            margin-bottom: 2rem;
            color: #34495e;
            line-height: 1.8;
            font-weight: 400;
        }
        
        .home-button {
            display: inline-block;
            padding: 18px 36px;
            background: linear-gradient(45deg, #3498db, #2980b9);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            border: none;
            transition: all 0.3s ease;
            box-shadow: 0 8px 20px rgba(52, 152, 219, 0.3);
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .home-button:hover {
            background: linear-gradient(45deg, #2980b9, #3498db);
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(52, 152, 219, 0.4);
        }
        
        /* 火箭动画 */
        .rocket {
            position: absolute;
            top: 20%;
            right: 15%;
            font-size: 3rem;
            animation: rocket-spin 4s linear infinite;
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.2));
        }
        
        @keyframes rocket-spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* 星球轨道动画 */
        .planets {
            position: absolute;
            width: 300px;
            height: 300px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1;
        }
        
        .planet {
            position: absolute;
            border-radius: 50%;
            animation: orbit 10s linear infinite;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        }
        
        .planet1 {
            width: 20px;
            height: 20px;
            background: linear-gradient(45deg, #ff7675, #fd79a8);
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            animation-duration: 8s;
        }
        
        .planet2 {
            width: 15px;
            height: 15px;
            background: linear-gradient(45deg, #00b894, #00cec9);
            top: 50%;
            right: 0;
            transform: translateY(-50%);
            animation-duration: 12s;
            animation-direction: reverse;
        }
        
        .planet3 {
            width: 18px;
            height: 18px;
            background: linear-gradient(45deg, #fdcb6e, #f39c12);
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            animation-duration: 15s;
        }
        
        @keyframes orbit {
            0% { transform: rotate(0deg) translateX(150px) rotate(0deg); }
            100% { transform: rotate(360deg) translateX(150px) rotate(-360deg); }
        }
        
        /* 响应式设计 */
        @media (max-width: 768px) {
            .container {
                padding: 40px 30px;
                margin: 20px;
            }
            
            .error-code {
                font-size: 5rem;
            }
            
            .error-title {
                font-size: 1.5rem;
            }
            
            .error-message {
                font-size: 1rem;
                padding: 0 10px;
            }
            
            .rocket {
                font-size: 2rem;
                top: 10%;
                right: 10%;
            }
            
            .planets {
                width: 200px;
                height: 200px;
            }
            
            .planet1, .planet2, .planet3 {
                width: 12px;
                height: 12px;
            }
        }
    </style>
</head>
<body>
    <!-- 星空背景 -->
    <div class="stars">
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
        <div class="star"></div>
    </div>
    
    <!-- 火箭 -->
    <div class="rocket">🚀</div>
    
    <!-- 星球轨道 -->
    <div class="planets">
        <div class="planet planet1"></div>
        <div class="planet planet2"></div>
        <div class="planet planet3"></div>
    </div>
    
    <!-- 主内容 -->
    <div class="container">
        <div class="error-code">404</div>
        <h1 class="error-title">哎呀！文件飞到外太空了 🌌</h1>
        <p class="error-message">
            看起来您要找的页面搭乘火箭飞向了遥远的星系...<br>
            我们的宇航员正在努力寻找，但可能需要一些时间。<br>
            不如先回到地球上看看其他精彩内容吧！
        </p>
        <a href="/" class="home-button">🌍 返回地球首页</a>
    </div>
</body>
</html>
