<?php
/**
 * 管理后台导航组件
 * 统一管理所有后台页面的导航菜单
 */

function renderAdminNavigation($current_page = '') {
    $nav_items = [
        'dashboard' => [
            'url' => '/admin',
            'title' => '仪表盘',
            'icon' => 'dashboard'
        ],
        'posts' => [
            'url' => '/admin/posts',
            'title' => '文章管理',
            'icon' => 'posts'
        ],
        'comments' => [
            'url' => '/admin/comment-management',
            'title' => '评论管理',
            'icon' => 'comments'
        ],
        'create-post' => [
            'url' => '/admin/create-post',
            'title' => '发布文章',
            'icon' => 'create'
        ],
        'users' => [
            'url' => '/admin/user-management',
            'title' => '用户管理',
            'icon' => 'users'
        ],
        'settings' => [
            'url' => '/admin/settings',
            'title' => '系统设置',
            'icon' => 'settings'
        ],
        'admin-settings' => [
            'url' => '/admin/admin-settings',
            'title' => '管理员设置',
            'icon' => 'admin'
        ]
    ];
    
    echo '<div class="admin-sidebar">';
    echo '<h2>管理后台</h2>';
    echo '<nav>';
    
    // 添加返回首页按钮
    echo '<a href="/" class="home-link">← 返回首页</a>';
    echo '<div class="nav-divider"></div>';
    
    foreach ($nav_items as $key => $item) {
        $active_class = ($current_page === $key) ? ' class="active"' : '';
        echo '<a href="' . $item['url'] . '"' . $active_class . '>' . $item['title'] . '</a>';
    }
    
    echo '<div class="nav-divider"></div>';
    echo '<a href="/api/logout">退出登录</a>';
    echo '</nav>';
    echo '</div>';
}

/**
 * 获取当前页面标识
 */
function getCurrentPageKey() {
    $current_file = basename($_SERVER['PHP_SELF'], '.php');
    
    $page_mapping = [
        'index' => 'dashboard',
        'posts' => 'posts',
        'create-post' => 'create-post',
        'comment-management' => 'comments',
        'user-management' => 'users',
        'settings' => 'settings',
        'admin-settings' => 'admin-settings'
    ];
    
    return $page_mapping[$current_file] ?? '';
}
?>