<?php
// 网站基本配置
define('SITE_NAME', '朋友圈日记');
define('SITE_URL', 'https://diary.digac.edu.kg');
define('SITE_DESCRIPTION', '一个类似微信朋友圈的推文系统');

// 路径配置
define('ROOT_PATH', dirname(__DIR__));
define('DATA_PATH', ROOT_PATH . '/data');
define('POSTS_PATH', DATA_PATH . '/posts');
define('COMMENTS_PATH', DATA_PATH . '/comments');
define('USERS_PATH', DATA_PATH . '/users');
define('UPLOADS_PATH', ROOT_PATH . '/uploads');

// 默认管理员配置
define('DEFAULT_ADMIN_USER', 'tan');
define('DEFAULT_ADMIN_PASS', 'ng057720');
define('DEFAULT_ADMIN_NICK', 'M.T');

// 时区设置
date_default_timezone_set('Asia/Shanghai');

// 创建必要的目录
$directories = [
    DATA_PATH,
    POSTS_PATH,
    COMMENTS_PATH,
    USERS_PATH,
    UPLOADS_PATH
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }
}

// 初始化管理员用户
$admin_file = USERS_PATH . '/admin.json';
if (!file_exists($admin_file)) {
    $admin_data = [
        'username' => DEFAULT_ADMIN_USER,
        'password' => password_hash(DEFAULT_ADMIN_PASS, PASSWORD_DEFAULT),
        'nickname' => DEFAULT_ADMIN_NICK,
        'role' => 'admin',
        'created_at' => date('Y-m-d H:i:s')
    ];
    file_put_contents($admin_file, json_encode($admin_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}
?>