<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin');
    exit;
}

// 处理用户操作
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'create_user':
                $username = sanitizeInput($_POST['username']);
                $password = $_POST['password'];
                $role = sanitizeInput($_POST['role']);
                
                if (createUser($username, $password, $role)) {
                    $success_message = '用户创建成功';
                } else {
                    $error_message = '用户创建失败';
                }
                break;
                
            case 'delete_user':
                $username = sanitizeInput($_POST['username']);
                if (deleteUser($username)) {
                    $success_message = '用户删除成功';
                } else {
                    $error_message = '用户删除失败';
                }
                break;
        }
    }
}

// 获取所有用户
$users = getAllUsers();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>用户管理 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css?v=<?php echo time(); ?>">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('users'); ?>
        
        <main class="admin-main" style="display: flex; justify-content: center; align-items: flex-start; min-height: 100vh; padding: 20px;">
            <div style="width: 100%; max-width: 1200px; margin: 0 auto;">
                <div class="page-header" style="text-align: center; margin-bottom: 30px;">
                    <h2 style="color: #333; font-size: 28px; margin: 0;">用户管理</h2>
                </div>
                
                <?php if (isset($success_message)): ?>
                    <div class="alert alert-success" style="background: #d4edda; color: #155724; padding: 12px 20px; border-radius: 6px; margin-bottom: 20px; text-align: center; border: 1px solid #c3e6cb;"><?php echo $success_message; ?></div>
                <?php endif; ?>
                
                <?php if (isset($error_message)): ?>
                    <div class="alert alert-error" style="background: #f8d7da; color: #721c24; padding: 12px 20px; border-radius: 6px; margin-bottom: 20px; text-align: center; border: 1px solid #f5c6cb;"><?php echo $error_message; ?></div>
                <?php endif; ?>
                
                <div class="admin-content user-management">
                    <!-- 创建用户表单 -->
                    <div class="create-user-section" style="background: #fff; padding: 25px; border-radius: 10px; margin-bottom: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border: 1px solid #e9ecef;">
                        <h3 style="text-align: center; margin-bottom: 20px; color: #495057; font-size: 20px; font-weight: 600;">创建新用户</h3>
                        <form method="POST" class="user-form" style="max-width: 700px; margin: 0 auto;">
                            <input type="hidden" name="action" value="create_user">
                            
                            <div class="form-row" style="display: flex; gap: 15px; align-items: end; flex-wrap: nowrap; margin-bottom: 18px; justify-content: center;">
                                <div class="form-group" style="flex: 1; text-align: center;">
                                    <label for="username" style="display: block; margin-bottom: 6px; font-weight: 500; color: #495057; font-size: 14px;">用户名</label>
                                    <input type="text" id="username" name="username" required style="height: 40px; padding: 8px 12px; font-size: 14px; border: 1px solid #ced4da; border-radius: 5px; box-sizing: border-box; width: 100%; text-align: center; transition: border-color 0.15s ease-in-out;">
                                </div>
                                
                                <div class="form-group" style="flex: 1; text-align: center;">
                                    <label for="password" style="display: block; margin-bottom: 6px; font-weight: 500; color: #495057; font-size: 14px;">密码</label>
                                    <input type="password" id="password" name="password" required style="height: 40px; padding: 8px 12px; font-size: 14px; border: 1px solid #ced4da; border-radius: 5px; box-sizing: border-box; width: 100%; text-align: center; transition: border-color 0.15s ease-in-out;">
                                </div>
                                
                                <div class="form-group" style="flex: 1; text-align: center;">
                                    <label for="role" style="display: block; margin-bottom: 6px; font-weight: 500; color: #495057; font-size: 14px;">角色</label>
                                    <select id="role" name="role" style="height: 40px; padding: 8px 12px; font-size: 14px; border: 1px solid #ced4da; border-radius: 5px; box-sizing: border-box; width: 100%; text-align: center; transition: border-color 0.15s ease-in-out;">
                                        <option value="admin">管理员</option>
                                        <option value="editor">编辑</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="form-row" style="text-align: center; margin-top: 20px;">
                                <button type="submit" class="btn btn-primary" style="height: 40px; padding: 10px 25px; font-size: 14px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-weight: 500; transition: background-color 0.15s ease-in-out;">创建用户</button>
                            </div>
                        </form>
                    </div>
                    
                    <!-- 用户列表 -->
                    <div class="users-section" style="background: #fff; padding: 25px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); border: 1px solid #e9ecef;">
                        <h3 style="text-align: center; margin-bottom: 20px; color: #495057; font-size: 20px; font-weight: 600;">现有用户</h3>
                        <?php if (empty($users)): ?>
                            <p class="no-users" style="text-align: center; color: #6c757d; font-size: 16px; margin: 30px 0;">暂无用户</p>
                        <?php else: ?>
                            <div class="users-table" style="overflow-x: auto;">
                                <table style="width: 100%; border-collapse: collapse; margin: 0 auto; background: #fff; font-size: 14px;">
                                    <thead>
                                        <tr style="background-color: #f8f9fa;">
                                            <th style="padding: 12px 15px; text-align: center; border: 1px solid #dee2e6; font-weight: 600; color: #495057;">用户名</th>
                                            <th style="padding: 12px 15px; text-align: center; border: 1px solid #dee2e6; font-weight: 600; color: #495057;">角色</th>
                                            <th style="padding: 12px 15px; text-align: center; border: 1px solid #dee2e6; font-weight: 600; color: #495057;">创建时间</th>
                                            <th style="padding: 12px 15px; text-align: center; border: 1px solid #dee2e6; font-weight: 600; color: #495057;">操作</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($users as $user): ?>
                                        <tr style="border-bottom: 1px solid #dee2e6; transition: background-color 0.15s ease-in-out;" onmouseover="this.style.backgroundColor='#f8f9fa'" onmouseout="this.style.backgroundColor='transparent'">
                                            <td style="padding: 10px 15px; text-align: center; border: 1px solid #dee2e6;"><?php echo htmlspecialchars($user['username']); ?></td>
                                            <td style="padding: 10px 15px; text-align: center; border: 1px solid #dee2e6;">
                                                <?php 
                                                $roleNames = [
                                                    'admin' => '管理员',
                                                    'editor' => '编辑'
                                                ];
                                                echo htmlspecialchars($roleNames[$user['role']] ?? $user['role']); 
                                                ?>
                                            </td>
                                            <td style="padding: 10px 15px; text-align: center; border: 1px solid #dee2e6;"><?php echo isset($user['created_at']) ? formatDate($user['created_at']) : '未知'; ?></td>
                                            <td style="padding: 10px 15px; text-align: center; border: 1px solid #dee2e6;">
                                                <?php if ($user['username'] !== 'admin'): ?>
                                                    <a href="edit-user?username=<?php echo urlencode($user['username']); ?>" class="btn btn-secondary btn-sm" style="padding: 5px 10px; margin-right: 5px; background-color: #6c757d; color: white; text-decoration: none; border-radius: 3px; font-size: 12px; transition: background-color 0.15s ease-in-out;">编辑</a>
                                                    <form method="POST" style="display: inline;" onsubmit="return confirm('确定要删除此用户吗？')">
                                                        <input type="hidden" name="action" value="delete_user">
                                                        <input type="hidden" name="username" value="<?php echo htmlspecialchars($user['username']); ?>">
                                                        <button type="submit" class="btn btn-danger btn-sm" style="padding: 5px 10px; background-color: #dc3545; color: white; border: none; border-radius: 3px; cursor: pointer; font-size: 12px; transition: background-color 0.15s ease-in-out;">删除</button>
                                                    </form>
                                                <?php else: ?>
                                                    <span class="text-muted" style="color: #6c757d; font-style: italic; font-size: 12px;">系统管理员</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>