<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin');
    exit;
}

// 处理文章操作
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $post_id = $_POST['post_id'] ?? '';
    
    if ($action === 'delete' && $post_id) {
        if (deletePost($post_id)) {
            $message = '文章已删除';
        } else {
            $error_message = '删除失败';
        }
    } elseif ($action === 'toggle_status' && $post_id) {
        $current_status = $_POST['current_status'] ?? '';
        $new_status = $current_status === 'published' ? 'draft' : 'published';
        
        if (updatePostStatus($post_id, $new_status)) {
            $message = '文章状态已更新';
        } else {
            $error_message = '更新失败';
        }
    }
}

// 检查是否有更新成功的消息
if (isset($_GET['updated']) && $_GET['updated'] == '1') {
    $message = '文章更新成功！';
}

// 获取所有文章
$posts = getAllPosts();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>文章管理 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('posts'); ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h2>文章管理</h2>
                <a href="/admin/create-post" class="btn btn-primary">发布新文章</a>
            </div>
            
            <?php if (isset($message)): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-error"><?php echo $error_message; ?></div>
            <?php endif; ?>
            
            <div class="posts-container">
                <?php if (empty($posts)): ?>
                    <div class="empty-state">
                        <p>暂无文章</p>
                        <a href="/admin/create-post" class="btn btn-primary">发布第一篇文章</a>
                    </div>
                <?php else: ?>
                    <div class="posts-table">
                        <div class="table-header">
                            <div class="col-title">标题</div>
                            <div class="col-status">状态</div>
                            <div class="col-date">发布时间</div>
                            <div class="col-actions">操作</div>
                        </div>
                        
                        <?php foreach ($posts as $post): ?>
                            <div class="table-row">
                                <div class="col-title">
                                    <h4><?php echo htmlspecialchars($post['title']); ?></h4>
                                    <p class="post-excerpt"><?php echo htmlspecialchars(mb_substr(strip_tags($post['content']), 0, 100)); ?>...</p>
                                </div>
                                <div class="col-status">
                                    <span class="status-badge status-<?php echo $post['status'] ?? 'published'; ?>">
                                        <?php echo ($post['status'] ?? 'published') === 'published' ? '已发布' : '草稿'; ?>
                                    </span>
                                </div>
                                <div class="col-date">
                                    <?php echo formatDate($post['created_at']); ?>
                                </div>
                                <div class="col-actions">
                                    <a href="/admin/edit-post?id=<?php echo $post['id']; ?>" class="btn btn-sm btn-secondary">编辑</a>
                                    <a href="/<?php echo date('Y/m/d', strtotime($post['created_at'])); ?>/<?php echo $post['slug']; ?>.html" class="btn btn-sm btn-secondary" target="_blank">查看</a>
                                    
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="toggle_status">
                                        <input type="hidden" name="post_id" value="<?php echo $post['id']; ?>">
                                        <input type="hidden" name="current_status" value="<?php echo $post['status'] ?? 'published'; ?>">
                                        <button type="submit" class="btn btn-sm btn-warning">
                                            <?php echo ($post['status'] ?? 'published') === 'published' ? '设为草稿' : '发布'; ?>
                                        </button>
                                    </form>
                                    
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="delete">
                                        <input type="hidden" name="post_id" value="<?php echo $post['id']; ?>">
                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('确定要删除这篇文章吗？')">删除</button>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</body>
</html>