<?php
// 设置会话保存路径
$session_path = __DIR__ . '/../data/sessions';
if (!is_dir($session_path)) {
    mkdir($session_path, 0777, true);
}
session_save_path($session_path);

// 设置会话参数
session_set_cookie_params([
    'lifetime' => 0,
    'path' => '/',
    'domain' => '',
    'secure' => false,
    'httponly' => true,
    'samesite' => 'Lax'
]);

// 启动会话
session_start();

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin/login.php');
    exit();
}

$posts = getAllPosts();
$all_comments = [];
$comment_files = glob(COMMENTS_PATH . '/*.json');
foreach ($comment_files as $file) {
    $comments = json_decode(file_get_contents($file), true);
    if ($comments) {
        $post_id = basename($file, '.json');
        foreach ($comments as $comment) {
            $comment['post_id'] = $post_id;
            $all_comments[] = $comment;
        }
    }
}

$pending_comments = array_filter($all_comments, function($comment) {
    return $comment['status'] === 'pending';
});
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>管理后台 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('dashboard'); ?>
        
        <div class="admin-main">
            <div class="admin-content">
                <h1>仪表盘</h1>
                
                <div class="stats-grid">
                    <div class="stat-card">
                        <h3>文章总数</h3>
                        <div class="stat-number"><?php echo count($posts); ?></div>
                    </div>
                    <div class="stat-card">
                        <h3>待审核评论</h3>
                        <div class="stat-number"><?php echo count($pending_comments); ?></div>
                    </div>
                    <div class="stat-card">
                        <h3>总评论数</h3>
                        <div class="stat-number"><?php echo count($all_comments); ?></div>
                    </div>
                </div>
                
                <div class="recent-section">
                    <h2>最新文章</h2>
                    <div class="recent-posts">
                        <?php foreach (array_slice($posts, 0, 5) as $post): ?>
                        <div class="recent-item">
                            <h4><?php echo htmlspecialchars($post['title'] ?? '无标题'); ?></h4>
                            <p><?php echo truncateText($post['content'], 100); ?></p>
                            <span class="recent-time"><?php echo formatDate($post['created_at']); ?></span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                
                <?php if (!empty($pending_comments)): ?>
                <div class="recent-section">
                    <h2>待审核评论</h2>
                    <div class="pending-comments">
                        <?php foreach (array_slice($pending_comments, 0, 5) as $comment): ?>
                        <div class="comment-item">
                            <strong><?php echo htmlspecialchars($comment['nickname']); ?></strong>
                            <p><?php echo htmlspecialchars($comment['content']); ?></p>
                            <div class="comment-actions">
                                <button onclick="approveComment('<?php echo $comment['post_id']; ?>', '<?php echo $comment['id']; ?>')">通过</button>
                                <button onclick="deleteComment('<?php echo $comment['post_id']; ?>', '<?php echo $comment['id']; ?>')">删除</button>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="/assets/js/admin.js"></script>
</body>
</html>
