<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin');
    exit;
}

$username = $_GET['username'] ?? '';
if (empty($username) || $username === 'admin') {
    header('Location: user-management.php');
    exit;
}

$user = getUser($username);
if (!$user) {
    header('Location: user-management.php');
    exit;
}

// 处理表单提交
if ($_POST) {
    $new_password = $_POST['password'] ?? '';
    $new_role = $_POST['role'] ?? '';
    
    if (!empty($new_password) || !empty($new_role)) {
        $user_data = $user;
        
        if (!empty($new_password)) {
            $user_data['password'] = password_hash($new_password, PASSWORD_DEFAULT);
        }
        
        if (!empty($new_role) && in_array($new_role, ['admin', 'editor'])) {
            $user_data['role'] = $new_role;
        }
        
        $user_data['updated_at'] = date('Y-m-d H:i:s');
        
        if (saveUser($user_data)) {
            $success = '用户信息更新成功！';
            $user = $user_data; // 更新显示的用户数据
        } else {
            $error = '用户信息更新失败';
        }
    } else {
        $error = '请至少填写一个要更新的字段';
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>编辑用户 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('user-management'); ?>
        
        <div class="admin-main">
            <div class="admin-content">
                <div class="page-header">
                    <h2>编辑用户：<?php echo htmlspecialchars($user['username']); ?></h2>
                    <a href="user-management" class="btn btn-secondary">返回用户管理</a>
                </div>
                
                <?php if (isset($error)): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
                <?php endif; ?>
                
                <?php if (isset($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <div class="settings-section">
                    <form method="POST" class="settings-form">
                        <h3>用户信息</h3>
                        
                        <div class="form-group">
                            <label>用户名</label>
                            <input type="text" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
                            <small>用户名不可修改</small>
                        </div>
                        
                        <div class="form-group">
                            <label>当前角色</label>
                            <input type="text" value="<?php echo htmlspecialchars($user['role']); ?>" disabled>
                        </div>
                        
                        <div class="form-group">
                            <label>创建时间</label>
                            <input type="text" value="<?php echo isset($user['created_at']) ? formatDate($user['created_at']) : '未知'; ?>" disabled>
                        </div>
                        
                        <h3>修改信息</h3>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="password">新密码（留空则不修改）</label>
                                <input type="password" id="password" name="password" placeholder="输入新密码">
                            </div>
                            
                            <div class="form-group">
                                <label for="role">角色</label>
                                <select id="role" name="role">
                                    <option value="">不修改</option>
                                    <option value="admin" <?php echo $user['role'] === 'admin' ? 'selected' : ''; ?>>管理员</option>
                                    <option value="editor" <?php echo $user['role'] === 'editor' ? 'selected' : ''; ?>>编辑</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">更新用户</button>
                            <a href="user-management" class="btn btn-secondary">取消</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
</html>