<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin');
    exit;
}

// 处理评论操作
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $post_id = $_POST['post_id'] ?? '';
    $comment_id = $_POST['comment_id'] ?? '';
    
    if ($action === 'approve' && $post_id && $comment_id) {
        updateCommentStatus($post_id, $comment_id, 'approved');
        $message = '评论已批准';
    } elseif ($action === 'reject' && $post_id && $comment_id) {
        updateCommentStatus($post_id, $comment_id, 'rejected');
        $message = '评论已拒绝';
    } elseif ($action === 'delete' && $post_id && $comment_id) {
        deleteComment($post_id, $comment_id);
        $message = '评论已删除';
    }
}

// 获取所有评论
$all_comments = getAllComments();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>评论管理 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('comment-management'); ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h2>评论管理</h2>
            </div>
            
            <?php if (isset($message)): ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <div class="admin-content comment-management">
                <div class="comments-container">
                <?php if (empty($all_comments)): ?>
                    <div class="empty-state">
                        <p>暂无评论</p>
                    </div>
                <?php else: ?>
                    <?php foreach ($all_comments as $comment): ?>
                        <div class="comment-item">
                            <div class="comment-header">
                                <div class="comment-meta">
                                    <strong><?php echo htmlspecialchars($comment['nickname']); ?></strong>
                                    <?php if (!empty($comment['email'])): ?>
                                        (<?php echo htmlspecialchars($comment['email']); ?>)
                                    <?php endif; ?>
                                    <span class="comment-date"><?php echo $comment['created_at']; ?></span>
                                    <span class="comment-status status-<?php echo $comment['status']; ?>">
                                        <?php 
                                            echo $comment['status'] === 'pending' ? '待审核' : 
                                                ($comment['status'] === 'approved' ? '已批准' : '已拒绝'); 
                                        ?>
                                    </span>
                                </div>
                            </div>
                            
                            <div class="comment-content">
                                <p><?php echo nl2br(htmlspecialchars($comment['content'])); ?></p>
                            </div>
                            
                            <div class="comment-post-info">
                                <small>文章：<?php echo htmlspecialchars($comment['post_title'] ?? $comment['post_id']); ?></small>
                            </div>
                            
                            <div class="comment-actions">
                                <?php if ($comment['status'] !== 'approved'): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="approve">
                                        <input type="hidden" name="post_id" value="<?php echo $comment['post_id']; ?>">
                                        <input type="hidden" name="comment_id" value="<?php echo $comment['id']; ?>">
                                        <button type="submit" class="btn btn-success">批准</button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if ($comment['status'] !== 'rejected'): ?>
                                    <form method="POST" style="display: inline;">
                                        <input type="hidden" name="action" value="reject">
                                        <input type="hidden" name="post_id" value="<?php echo $comment['post_id']; ?>">
                                        <input type="hidden" name="comment_id" value="<?php echo $comment['id']; ?>">
                                        <button type="submit" class="btn btn-warning">拒绝</button>
                                    </form>
                                <?php endif; ?>
                                
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="post_id" value="<?php echo $comment['post_id']; ?>">
                                    <input type="hidden" name="comment_id" value="<?php echo $comment['id']; ?>">
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('确定要删除这条评论吗？')">删除</button>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            </div>
        </main>
    </div>
</body>
</html>