<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';

if (!isAdmin()) {
    http_response_code(403);
    echo json_encode(['error' => '权限不足']);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => '方法不允许']);
    exit;
}

$action = $_POST['action'] ?? '';
$post_id = $_POST['post_id'] ?? '';
$comment_id = $_POST['comment_id'] ?? '';

if (empty($action) || empty($post_id) || empty($comment_id)) {
    http_response_code(400);
    echo json_encode(['error' => '参数不完整']);
    exit;
}

switch ($action) {
    case 'approve':
        if (approveComment($post_id, $comment_id)) {
            echo json_encode(['success' => true, 'message' => '评论已通过']);
        } else {
            http_response_code(500);
            echo json_encode(['error' => '操作失败']);
        }
        break;
        
    case 'delete':
        if (deleteComment($post_id, $comment_id)) {
            echo json_encode(['success' => true, 'message' => '评论已删除']);
        } else {
            http_response_code(500);
            echo json_encode(['error' => '操作失败']);
        }
        break;
        
    default:
        http_response_code(400);
        echo json_encode(['error' => '无效的操作']);
}
?>
