<?php
// 不需要再次启动会话，因为主index.php已经启动了
// session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/admin-navigation.php';

if (!isAdmin()) {
    header('Location: /admin');
    exit;
}

// 处理表单提交
if ($_POST) {
    $admin_file = USERS_PATH . '/admin.json';
    $admin_data = json_decode(file_get_contents($admin_file), true);
    
    if (isset($_POST['update_profile'])) {
        $admin_data['nickname'] = sanitizeInput($_POST['nickname']);
        
        if (file_put_contents($admin_file, json_encode($admin_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
            $success_message = '个人信息已更新';
            $_SESSION['user'] = $admin_data; // 更新session
        } else {
            $error_message = '更新失败';
        }
    }
    
    if (isset($_POST['change_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        if (!password_verify($current_password, $admin_data['password'])) {
            $error_message = '当前密码错误';
        } elseif ($new_password !== $confirm_password) {
            $error_message = '新密码确认不匹配';
        } elseif (strlen($new_password) < 6) {
            $error_message = '新密码长度至少6位';
        } else {
            $admin_data['password'] = password_hash($new_password, PASSWORD_DEFAULT);
            
            if (file_put_contents($admin_file, json_encode($admin_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
                $success_message = '密码已更新';
                $_SESSION['user'] = $admin_data; // 更新session
            } else {
                $error_message = '密码更新失败';
            }
        }
    }
}

$admin_data = json_decode(file_get_contents(USERS_PATH . '/admin.json'), true);
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>管理员设置 - <?php echo getSiteName(); ?></title>
    <link rel="stylesheet" href="/assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <?php renderAdminNavigation('admin-settings'); ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h2>管理员设置</h2>
            </div>
            
            <?php if (isset($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-error"><?php echo $error_message; ?></div>
            <?php endif; ?>
            
            <div class="admin-content admin-settings">
                <div class="settings-section">
                    <h3>个人信息</h3>
                    <form method="POST" class="settings-form">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="username">用户名</label>
                                <input type="text" id="username" value="<?php echo htmlspecialchars($admin_data['username']); ?>" disabled>
                                <small>用户名不可修改</small>
                            </div>
                            
                            <div class="form-group">
                                <label for="nickname">昵称</label>
                                <input type="text" id="nickname" name="nickname" value="<?php echo htmlspecialchars($admin_data['nickname']); ?>" required>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="role">角色</label>
                                <input type="text" id="role" value="<?php echo htmlspecialchars($admin_data['role']); ?>" disabled>
                            </div>
                            
                            <div class="form-group">
                                <label for="created_at">创建时间</label>
                                <input type="text" id="created_at" value="<?php echo formatDate($admin_data['created_at']); ?>" disabled>
                            </div>
                        </div>
                        
                        <button type="submit" name="update_profile" class="btn btn-primary">更新个人信息</button>
                    </form>
                </div>
                
                <div class="settings-section">
                    <h3>修改密码</h3>
                    <form method="POST" class="settings-form">
                        <div class="form-row">
                            <div class="form-group">
                                <label for="current_password">当前密码</label>
                                <input type="password" id="current_password" name="current_password" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="new_password">新密码</label>
                                <input type="password" id="new_password" name="new_password" minlength="6" required>
                                <small>密码长度至少6位</small>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="confirm_password">确认新密码</label>
                            <input type="password" id="confirm_password" name="confirm_password" minlength="6" required>
                        </div>
                        
                        <button type="submit" name="change_password" class="btn btn-primary">修改密码</button>
                    </form>
                </div>
            </div>
        </main>
    </div>
</body>
</html>