# 个人日记系统

一个轻量级的个人日记管理系统，支持文章发布、评论管理和后台管理功能。

## 系统特性

- 📝 文章发布和管理
- 💬 评论系统
- 👤 用户管理
- 🔐 管理员后台
- 📧 邮件通知
- 📱 响应式设计

## 技术栈

- PHP 7.4+
- JSON 文件存储
- PHPMailer 邮件发送
- 原生 JavaScript
- CSS3 响应式布局

## 目录结构

```
diary.digac.edu.kg/
├── admin/              # 管理后台
├── api/                # API接口
├── assets/             # 静态资源
├── config/             # 配置文件
├── data/               # 数据存储
├── includes/           # 公共函数
├── pages/              # 页面模板
├── src/                # 图片资源
├── uploads/            # 上传文件
├── vendor/             # Composer依赖
├── index.php           # 主入口文件
└── router.php          # 路由文件
```

## 安装部署

1. 上传文件到服务器
2. 确保 `data/` 目录有写权限
3. 配置 `config/config.php` 中的设置
4. 访问 `/admin/login.php` 进入管理后台

## 默认管理员

- 用户名: tan
- 密码: ng057720

## 系统要求

- PHP 7.4 或更高版本
- 支持 JSON 扩展
- 文件系统写权限

## 项目大小

总大小: 1.3MB
核心代码: 约 600KB
依赖包: 672KB