# 宝塔面板配置指导

## 🚀 如何在宝塔面板中配置伪静态规则

### 步骤1：进入网站设置
1. 登录宝塔面板
2. 点击左侧菜单 "网站"
3. 找到你的网站 `proxy.digac.edu.kg`
4. 点击右侧的 "设置" 按钮

### 步骤2：配置伪静态
1. 在网站设置页面中，点击 "伪静态" 选项卡
2. 清空现有的伪静态规则（如果有的话）
3. 复制 `bt_rewrite_rules.conf` 文件中的内容
4. 粘贴到伪静态规则框中
5. 点击 "保存" 按钮

### 步骤3：重启Nginx
1. 在宝塔面板左侧菜单点击 "软件商店"
2. 找到 "Nginx" 
3. 点击 "重启" 按钮

### 步骤4：测试配置
配置完成后，测试以下功能：

#### ✅ 登录功能测试
- 访问：`https://proxy.digac.edu.kg`
- 使用账号：`michaeltan@digac.icu`
- 使用密码：`ng057720`

#### ✅ API测试
- 登录API：`https://proxy.digac.edu.kg/api/login`
- 数据库测试：`https://proxy.digac.edu.kg/api/db-test`

#### ✅ 工具功能测试
- 失败记录：`https://proxy.digac.edu.kg/tools/log_failed_attempt.php`

## 🔧 重要说明

### PHP-FPM Socket 路径
伪静态规则中使用了 `unix:/tmp/php-cgi-80.sock`，这是宝塔面板的默认路径。

**🔧 如何检查你的PHP版本：**
1. 宝塔面板 → 网站 → 找到 `proxy.digac.edu.kg` → 设置 → PHP版本
2. 根据你的PHP版本，修改伪静态规则中的socket路径：
   - PHP 7.4: `unix:/tmp/php-cgi-74.sock`
   - PHP 8.0: `unix:/tmp/php-cgi-80.sock`
   - PHP 8.1: `unix:/tmp/php-cgi-81.sock`
   - PHP 8.2: `unix:/tmp/php-cgi-82.sock`
   - PHP 8.3: `unix:/tmp/php-cgi-83.sock`

**📝 修改方法：**
在伪静态规则的第一个 `location ~ \.php$` 块中，将 `fastcgi_pass unix:/tmp/php-cgi-80.sock;` 改为你对应的PHP版本。

### 如果遇到问题
1. 检查PHP版本和对应的socket路径
2. 确保网站目录权限正确（755）
3. 检查PHP-FPM是否正常运行
4. 查看宝塔面板的错误日志

## 📝 配置文件说明

- `bt_rewrite_rules.conf` - 宝塔面板伪静态规则
- `nginx.conf` - 完整的Nginx配置（仅供参考）
- `宝塔面板配置指导.md` - 本配置指导文档

## 🎯 预期效果

配置完成后：
1. ✅ 登录功能正常工作
2. ✅ 登录成功后正确跳转到面板
3. ✅ 错误登录会记录失败尝试（不再出现405错误）
4. ✅ 静态资源正常加载
5. ✅ 所有API路由正常工作