<?php
// API重定向处理
// 将/api/请求重定向到proxy.php/api/

$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$queryString = $_SERVER['QUERY_STRING'] ?? '';

// 构建proxy.php的完整路径
$redirectUrl = '/proxy.php' . $requestUri;

if ($queryString) {
    $redirectUrl .= '?' . $queryString;
}

// 对于AJAX请求，直接代理而不是重定向
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    // 直接包含proxy.php并修改路径
    $_SERVER['SCRIPT_NAME'] = '/proxy.php';
    $_SERVER['REQUEST_URI'] = '/proxy.php' . $requestUri;
    include __DIR__ . '/../proxy.php';
    exit;
}

// 使用302重定向
header('Location: ' . $redirectUrl, true, 302);
exit;
?>