<?php
// PHP内置服务器路由文件
// 用于处理API请求和静态文件

$requestUri = $_SERVER['REQUEST_URI'];
$path = parse_url($requestUri, PHP_URL_PATH);

// 处理静态文件
if (preg_match('/\.(css|js|png|jpg|jpeg|gif|ico|svg|woff|woff2|ttf|eot)$/', $path)) {
    return false; // 让PHP内置服务器处理静态文件
}

// API路由
if (strpos($path, '/api/') === 0) {
    include 'auth_check_db.php';
    return true;
}

// 登录路由
if ($path === '/login') {
    include 'auth_check_db.php';
    return true;
}

// 配置页面路由
if ($path === '/config' || $path === '/config.html') {
    include 'auth_check_db.php';
    return true;
}

// 503页面路由
if ($path === '/503' || $path === '/503.html') {
    include '503.html';
    return true;
}

// Tools路由
if (strpos($path, '/tools/') === 0) {
    $filePath = '.' . $path;
    if (file_exists($filePath)) {
        include $filePath;
        return true;
    }
}

// 根目录和其他路由
include 'auth_check_db.php';
return true;
?>