<?php

class DatabaseAuth {
    private $config;
    private $db;
    
    public function __construct() {
        $configFile = __DIR__ . '/../.config/auth/config.json';
        if (!file_exists($configFile)) {
            throw new Exception('Auth config file not found');
        }
        $this->config = json_decode(file_get_contents($configFile), true);
        
        // 连接SQLite数据库
        $dbPath = __DIR__ . '/../users.db';
        try {
            $this->db = new PDO('sqlite:' . $dbPath);
            $this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            throw new Exception('Database connection failed: ' . $e->getMessage());
        }
    }
    
    public function validateUser($email, $password) {
        try {
            error_log("DatabaseAuth: Validating user $email with password $password");
            
            // 从数据库查询用户
            $stmt = $this->db->prepare('SELECT * FROM users WHERE email = ?');
            $stmt->execute([$email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            error_log("DatabaseAuth: User query result: " . json_encode($user));
            
            if ($user) {
                error_log("DatabaseAuth: Comparing passwords - DB: '{$user['password']}', Input: '$password'");
                // 检查密码（支持明文和哈希密码）
                if ($user['password'] === $password || password_verify($password, $user['password'])) {
                    error_log("DatabaseAuth: Password match successful");
                    // 返回用户信息数组
                    return [
                        'email' => $email,
                        'name' => $this->getUserName($email),
                        'expired_at' => $this->getUserExpiryDate($email)
                    ];
                } else {
                    error_log("DatabaseAuth: Password mismatch");
                }
            } else {
                error_log("DatabaseAuth: User not found in database");
            }
            
            return false;
        } catch (PDOException $e) {
            error_log('Database query error: ' . $e->getMessage());
            return false;
        }
    }
    
    public function getUserExpiryDate($email) {
        // 硬编码的用户到期时间（用于测试不同的到期状态）
        $userExpiry = [
            'michaeltan@digac.icu' => '2025-01-01', // 可以修改这个日期来测试不同的状态
            'test@example.com' => '2024-12-30'     // 测试用户
        ];
        
        return isset($userExpiry[$email]) ? $userExpiry[$email] : null;
    }
    
    public function getDaysUntilExpiry($email) {
        $expiryDate = $this->getUserExpiryDate($email);
        if (!$expiryDate) {
            return null;
        }
        
        $today = new DateTime();
        $expiry = new DateTime($expiryDate);
        $interval = $today->diff($expiry);
        
        // 如果已过期，返回负数
        if ($today > $expiry) {
            return -$interval->days;
        }
        
        return $interval->days;
    }
    
    public function getUserName($email) {
        // 硬编码的用户名信息（remarks字段）
        $userNames = [
            'michaeltan@digac.icu' => 'Michael Tan',
            'test@example.com' => '测试用户'
        ];
        
        return isset($userNames[$email]) ? $userNames[$email] : null;
    }
    
    public function isConnected() {
        // 简单的连接检查，对于硬编码数据总是返回true
        return true;
    }
    
    public function testConnection() {
        // 简单的连接测试，返回成功
        return [
            'success' => true,
            'message' => 'Database connection successful'
        ];
    }
}