<?php
header('Content-Type: application/json');

$logFile = __DIR__ . '/failed_attempts.log';
$response = ['success' => false, 'message' => 'Invalid request'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    if (isset($data['timestamp']) && isset($data['passwordAttempt'])) {
        // 获取客户端IP
        $ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
        $entry = [
            'timestamp' => $data['timestamp'],
            'ip' => $ip,
            'passwordAttempt' => $data['passwordAttempt']
        ];
        // 追加写入日志文件，每行一个JSON对象
        $line = json_encode($entry, JSON_UNESCAPED_UNICODE) . "\n";
        if (file_put_contents($logFile, $line, FILE_APPEND | LOCK_EX) !== false) {
            $response['success'] = true;
            $response['message'] = 'Logged failed attempt';
        } else {
            $response['message'] = 'Failed to write log';
        }
    } else {
        $response['message'] = 'Missing timestamp or passwordAttempt';
    }
}
echo json_encode($response);
?>