<?php
// PHP路由器 - 模拟.htaccess的URL重写行为

session_start();

$request_uri = $_SERVER['REQUEST_URI'];
$request_path = parse_url($request_uri, PHP_URL_PATH);

// 如果直接访问proxy.php，重定向到根目录
if ($request_path === '/proxy.php') {
    header('Location: /', true, 301);
    exit;
}

// 检查鉴权状态的函数
function isAuthenticated() {
    // 检查session中的认证令牌
    if (isset($_SESSION['authToken']) && !empty($_SESSION['authToken'])) {
        return true;
    }
    
    // 检查sessionStorage中的认证令牌（通过JavaScript设置的cookie）
    if (isset($_COOKIE['authToken']) && !empty($_COOKIE['authToken'])) {
        return true;
    }
    
    return false;
}

// 处理根路径
if ($request_path === '/') {
    // 检查是否已经鉴权
    if (!isAuthenticated()) {
        // 未鉴权，显示登录页面
        include 'index.html';
        exit;
    }
    
    // 已鉴权，加载proxy.php内容
    // 保存原始REQUEST_URI
    $original_request_uri = $_SERVER['REQUEST_URI'];
    
    // 临时设置REQUEST_URI和SCRIPT_NAME为proxy.php
    $_SERVER['REQUEST_URI'] = '/proxy.php';
    $_SERVER['SCRIPT_NAME'] = '/proxy.php';
    
    // 包含proxy.php
    include 'proxy.php';
    exit;
}

// 移除开头的斜杠
$path = ltrim($request_path, '/');

// 如果请求包含.php或.html扩展名，重定向到无扩展名版本
if (preg_match('/^(.+)\.(php|html)$/', $path, $matches)) {
    $cleanPath = $matches[1];
    $redirectUrl = '/' . $cleanPath;
    if (!empty($_SERVER['QUERY_STRING'])) {
        $redirectUrl .= '?' . $_SERVER['QUERY_STRING'];
    }
    header('Location: ' . $redirectUrl, true, 301);
    exit;
}

// 处理API请求
if (strpos($path, 'api/') === 0) {
    $_SERVER['REQUEST_URI'] = '/proxy.php/' . $requestUri;
    include 'proxy.php';
    exit;
}

// 处理静态资源请求
if (preg_match('/^(uploads|theme|assets)\//', $path)) {
    $_SERVER['REQUEST_URI'] = '/proxy.php/' . $requestUri;
    include 'proxy.php';
    exit;
}

// 处理favicon请求
if ($path === 'favicon.ico') {
    header('Location: /src/favicon.svg', true, 301);
    exit;
}

// 检查是否存在对应的.php文件
if (file_exists($path . '.php')) {
    include $path . '.php';
    exit;
}

// 检查是否存在对应的.html文件
if (file_exists($path . '.html')) {
    include $path . '.html';
    exit;
}

// 如果是其他路径，尝试通过proxy.php处理
if (!empty($path)) {
    $_SERVER['REQUEST_URI'] = '/proxy.php/' . $requestUri;
    include 'proxy.php';
    exit;
}

// 默认情况下，显示404
http_response_code(404);
echo '<!DOCTYPE html>
<html>
<head>
    <title>404 Not Found</title>
</head>
<body>
    <h1>404 Not Found</h1>
    <p>The requested URL was not found on this server.</p>
</body>
</html>';
?>