<?php
// 鉴权检查文件 - 供.htaccess规则使用

session_start();

// 检查鉴权状态的函数
function isAuthenticated() {
    // 检查session中的认证令牌
    if (isset($_SESSION['authToken']) && !empty($_SESSION['authToken'])) {
        return true;
    }
    
    // 检查cookie中的认证令牌
    if (isset($_COOKIE['authToken']) && !empty($_COOKIE['authToken'])) {
        return true;
    }
    
    return false;
}

// 获取请求路径
$request_uri = $_SERVER['REQUEST_URI'] ?? '/';
$request_path = parse_url($request_uri, PHP_URL_PATH);

// 如果是根路径访问
if ($request_path === '/') {
    if (!isAuthenticated()) {
        // 未鉴权，显示登录页面
        include 'index.html';
        exit;
    } else {
        // 已鉴权，重定向到proxy.php（内部重写）
        $_SERVER['REQUEST_URI'] = '/proxy.php';
        $_SERVER['SCRIPT_NAME'] = '/proxy.php';
        include 'proxy.php';
        exit;
    }
}

// 其他路径，继续正常处理
?>