<?php
// API重定向脚本
// 将/api/请求重定向到proxy.php/api/

$requestUri = $_SERVER['REQUEST_URI'] ?? '/';
$queryString = $_SERVER['QUERY_STRING'] ?? '';

// 移除/api前缀，构建proxy.php的路径
$path = preg_replace('#^/api#', '', $requestUri);
$redirectUrl = '/proxy.php/api' . $path;

if ($queryString) {
    $redirectUrl .= '?' . $queryString;
}

// 使用302重定向
header('Location: ' . $redirectUrl, true, 302);
exit;
?>