# Nginx 部署配置说明

## 配置文件说明

本项目提供了三个 Nginx 配置文件：

1. **`nginx.conf`** - 完整的 server 块配置
2. **`nginx_rewrite.conf`** - 伪静态规则文件（推荐）
3. **`bt_nginx_rules.conf`** - 宝塔面板专用伪静态规则（最简化）

## 部署方法

### 方法一：使用完整配置文件（推荐新站点）

1. 将 `nginx.conf` 复制到 Nginx 配置目录：
```bash
sudo cp nginx.conf /etc/nginx/sites-available/proxy.digac.edu.kg
sudo ln -s /etc/nginx/sites-available/proxy.digac.edu.kg /etc/nginx/sites-enabled/
```

2. 修改配置文件中的域名和路径：
```bash
sudo nano /etc/nginx/sites-available/proxy.digac.edu.kg
```

3. 测试配置并重载：
```bash
sudo nginx -t
sudo systemctl reload nginx
```

### 方法二：集成到现有配置（推荐现有站点）

1. 在现有的 server 块中添加 include 指令：
```nginx
server {
    listen 80;
    server_name proxy.digac.edu.kg;
    root /www/wwwroot/proxy.digac.edu.kg;
    
    # 包含伪静态规则
    include /www/wwwroot/proxy.digac.edu.kg/nginx_rewrite.conf;
    
    # PHP 处理（如果还没有配置）
    location ~ \.php$ {
        try_files $uri =404;
        fastcgi_pass unix:/tmp/php-cgi.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

2. 重载 Nginx 配置：
```bash
sudo nginx -t
sudo systemctl reload nginx
```

### 方法三：宝塔面板配置（推荐宝塔用户）

1. 登录宝塔面板
2. 进入 **网站** -> 选择你的网站 -> **伪静态**
3. 复制 `bt_nginx_rules.conf` 文件中的内容
4. 粘贴到伪静态规则框中
5. 点击 **保存**

**注意**：如果保存时提示配置错误，请确保：
- 删除任何现有的伪静态规则
- 确保网站根目录路径正确
- 确保 PHP 版本已正确配置

## 配置要点

### 1. PHP-FPM 配置
确保 `fastcgi_pass` 指向正确的 PHP-FPM socket 或端口：
- Socket: `unix:/tmp/php-cgi.sock`
- TCP: `127.0.0.1:9000`

### 2. 域名配置
修改 `server_name` 为你的实际域名：
```nginx
server_name proxy.digac.edu.kg;  # 替换为你的域名
```

### 3. 路径配置
确保 `root` 指向正确的网站根目录：
```nginx
root /www/wwwroot/proxy.digac.edu.kg;
```

### 4. 日志配置
根据需要调整日志路径：
```nginx
access_log /var/log/nginx/proxy_access.log;
error_log /var/log/nginx/proxy_error.log;
```

## 功能特性

### URL 美化
- ✅ 隐藏 `.php` 扩展名（排除 `proxy.php`）
- ✅ 隐藏 `.html` 扩展名
- ✅ 直接访问 `proxy.php` 重定向到根目录
- ✅ 根域名访问通过鉴权检查

### 安全配置
- ✅ 禁止访问隐藏文件（`.` 开头）
- ✅ 禁止访问敏感文件（`.sql`, `.bak`, `.log` 等）
- ✅ 禁止访问配置文件（`.config`, `config.json`, `.env`）
- ✅ 安全头设置（X-Frame-Options, X-XSS-Protection 等）

### 性能优化
- ✅ 静态资源缓存（30天）
- ✅ Gzip 压缩（需要在主配置中启用）
- ✅ FastCGI 缓冲区优化

### API 和静态资源
- ✅ API 请求路由到 `api.php`
- ✅ Favicon 优先使用 SVG 格式
- ✅ 静态资源长期缓存

## 测试配置

部署后可以测试以下功能：

1. **根域名访问**：`http://your-domain.com/` → 显示登录页面
2. **隐藏扩展名**：`http://your-domain.com/space` → 访问 `space.html`
3. **API 请求**：`http://your-domain.com/api/test` → 路由到 `api.php`
4. **直接访问重定向**：`http://your-domain.com/proxy.php` → 重定向到根目录
5. **安全测试**：`http://your-domain.com/.config/` → 403 Forbidden

## 故障排除

### 1. 配置语法错误
如果遇到 `unknown "1" variable` 错误，请使用 `bt_nginx_rules.conf` 或 `bt_simple.conf`。

### 2. 配置文件 403 错误
如果出现 `GET /.config/auth/config.json 403 (Forbidden)` 错误：
- 确保使用了修复后的配置文件（包含允许访问 config.json 的规则）
- 可以先使用 `bt_test.conf` 进行测试
- 检查文件权限：`chmod 644 .config/auth/config.json`

### 3. 502 Bad Gateway
- 检查 PHP-FPM 是否运行：`sudo systemctl status php-fpm`
- 检查 socket 路径是否正确
- 检查文件权限

### 4. 404 Not Found
- 检查网站根目录路径
- 检查文件是否存在
- 检查 Nginx 用户权限

### 5. 403 Forbidden
- 检查目录权限：`chmod 755`
- 检查文件权限：`chmod 644`
- 检查 Nginx 用户和组

### 6. 重写规则不生效
- 确保没有其他 location 块冲突
- 检查规则顺序（更具体的规则应该在前面）
- 使用 `nginx -t` 检查语法

## 与 .htaccess 的对比

| 功能 | .htaccess (Apache) | nginx.conf (Nginx) |
|------|-------------------|-------------------|
| 直接访问 proxy.php 重定向 | ✅ | ✅ |
| 隐藏 .php 扩展名 | ✅ | ✅ |
| 隐藏 .html 扩展名 | ✅ | ✅ |
| 根目录鉴权检查 | ✅ | ✅ |
| API 路由 | ✅ | ✅ |
| 静态资源缓存 | ✅ | ✅ |
| 安全配置 | ✅ | ✅ |
| 性能 | 较低 | 较高 |

Nginx 配置相比 .htaccess 具有更好的性能，但配置稍微复杂一些。