# 跨域名部署指南

## 概述
这个代理系统已经优化为支持在任何域名下部署，无需修改代码中的硬编码域名。

## 部署步骤

### 1. 文件上传
将以下文件和目录上传到新域名的服务器：
```
├── .config/
│   └── auth/
│       └── config.json
├── auth.js
├── index.html
├── proxy.php
├── space.html
├── src/
│   ├── favicon.svg
│   └── logo.png
└── tools/
    ├── failed_attempts.html
    ├── failed_attempts.log
    ├── hash.html
    ├── log_failed_attempt.php
    └── save_config.php
```

### 2. 配置文件检查
确保 `.config/auth/config.json` 文件包含正确的配置：
```json
{
    "redirectUrl": "https://www.023021.xyz",
    "salt": "your_salt_here",
    "passwordHash": "your_password_hash_here"
}
```

### 3. 服务器配置
确保服务器支持：
- PHP 7.4 或更高版本
- cURL 扩展
- 文件读写权限

### 4. 访问测试
部署完成后，访问以下URL进行测试：
- `https://your-domain.com/proxy.php` - 主页面
- `https://your-domain.com/proxy.php/.config/auth/config.json` - 配置文件
- `https://your-domain.com/proxy.php/auth.js` - 认证脚本

## 自动适配功能

### 域名自动检测
系统会自动检测当前访问的域名，无需手动配置：
- 使用 `$_SERVER['HTTP_HOST']` 获取当前域名
- 动态构建代理URL
- 自动重写响应中的URL引用

### URL重写规则
系统会自动重写以下类型的URL：
1. 目标网站的绝对URL → 代理URL
2. 当前域名的URL → 代理URL
3. 相对路径保持不变

## 常见问题排查

### 1. "未知错误"
可能原因：
- 配置文件权限问题
- PHP扩展缺失
- 网络连接问题

解决方法：
```bash
# 检查文件权限
chmod 644 .config/auth/config.json
chmod 755 .config/auth/
chmod 755 .config/

# 检查PHP扩展
php -m | grep curl
```

### 2. 404错误
可能原因：
- 文件路径不正确
- 服务器配置问题

解决方法：
- 确保所有文件都已上传
- 检查服务器的URL重写规则

### 3. 登录功能异常
可能原因：
- 配置文件无法加载
- JavaScript文件加载失败

解决方法：
- 检查浏览器开发者工具的Network标签
- 确认所有资源都能正常加载

## 安全建议

1. **隐藏配置目录**
   在服务器配置中隐藏 `.config` 目录：
   ```apache
   # Apache
   <Directory ".config">
       Require all denied
   </Directory>
   ```

2. **HTTPS强制**
   始终使用HTTPS访问代理系统

3. **定期更新密码**
   定期更新 `config.json` 中的密码哈希值

## 技术说明

### 动态域名支持
系统通过以下方式实现动态域名支持：
- 使用 `$_SERVER['HTTP_HOST']` 获取当前域名
- 在URL重写时动态替换域名引用
- 避免硬编码任何特定域名

### 本地文件处理
系统会优先处理本地文件请求：
- `.config/` 目录下的配置文件
- `auth.js` 认证脚本
- `tools/` 目录下的工具文件
- `src/` 目录下的静态资源

这确保了认证系统和工具在任何域名下都能正常工作。